<?php
declare(strict_types=1);

/**
 * Created by Aurélien RICHAUD (31/07/2019 11:03).
 */
require_once __DIR__ . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . 'classes' . \DIRECTORY_SEPARATOR . 'OAuthAuthCode.php';

class MyvetshopcliniqueApptokenModuleFrontController extends FrontController
{
    public function init(): void
    {
        $code = Tools::getValue('code');
        if (!$code) {
            header('HTTP/1.0 Bad Request');
            header('Content-Type: application/json');
            echo json_encode(['error' => 'Aucun AuthCode fourni'], \JSON_PRETTY_PRINT);
            exit;
        }

        $authCode = OAuthAuthCode::getByToken(strval($code));

        if (!$authCode) {
            header('HTTP/1.0 Bad Request');
            header('Content-Type: application/json');
            echo json_encode(['error' => 'AuthCode fourni invalide'], \JSON_PRETTY_PRINT);
            exit;
        } ?>
        <!doctype html>
        <html lang="en">
        <head>
            <meta charset="utf-8">
            <script type="text/javascript">
                window.authcode = <?php echo json_encode(
                    [
                        'token' => $authCode->token,
                        'created' => (int) $authCode->created,
                        'expires' => (int) $authCode->expires,
                    ]
                ); ?>;
            </script>
        </head>
        <body style="color: white; background-color: white;">
        <?php echo htmlentities($authCode->token); ?>
        </body>
        </html>
        <?php
        exit;
    }
}
