<?php

namespace Unit\Serializer;

use Myvetshop\Module\Clinique\Serializer\OrderReportingSerializer;
use PHPUnit\Framework\TestCase;

class OrderReportingSerializerTest extends TestCase
{
    public function testSerialize(): void
    {
        $dt = new \DateTimeImmutable();
        $orders = [
            [
                'id' => 1,
                'invoice_date' => $dt->format('Y-m-d H:i:s'),
                'state' => 21,
                'clinic_id' => 1,
                'supplier' => 'centravet',
                'total_products_wt' => '57.700000',
                'total_paid_tax_incl' => '57.700000',
            ],
        ];

        $products = [
            [
                'reference' => 'PRODUCT_ATTRIBUTE_HILLS_METABOLIC_CHICKEN_3KG',
                'name' => 'Chat Metabolic Poulet (format : Sac de 3 kg)',
                'category_id' => 4,
                'quantity' => 1,
                'purchase_price' => '28.870000',
                'price_tax_excl' => '48.080000',
                'total_price_tax_excl' => '48.080000',
                'total_price_tax_incl' => ' 57.700000',
                'order_id' => '1',
            ],
        ];

        $discounts = [];
        $refunds = [];

        $expectedPreparedOrders = [
            [
                'id' => 1,
                'invoice_date' => $dt->format(\DateTimeInterface::ATOM),
                'state' => 21,
                'clinic_id' => 1,
                'supplier' => 'centravet',
                'total_products_wt' => '57.700000',
                'total_paid_tax_incl' => '57.700000',
                'products' => [
                        [
                            'reference' => 'PRODUCT_ATTRIBUTE_HILLS_METABOLIC_CHICKEN_3KG',
                            'name' => 'Chat Metabolic Poulet (format : Sac de 3 kg)',
                            'category_id' => 4,
                            'quantity' => 1,
                            'purchase_price' => '28.870000',
                            'price_tax_excl' => '48.080000',
                            'total_price_tax_excl' => '48.080000',
                            'total_price_tax_incl' => ' 57.700000',
                        ],
                    ],
                'discounts' => [],
                'refunds' => [],
            ],
        ];

        $orders = OrderReportingSerializer::prepareOrdersArray($orders, $products, $discounts, $refunds);

        self::assertEquals($expectedPreparedOrders, $orders);

        self::assertEquals(
            $expectedPreparedOrders,
            \json_decode((new OrderReportingSerializer())->serialize($orders), true)
        );
    }
}
