<?php

namespace Unit\Accounting\Export\Repository;

use Myvetshop\Module\Clinique\Accounting\Export\Repository\InvoiceAddressRepository;
use PHPUnit\Framework\TestCase;

class InvoiceAddressRepositoryTest extends TestCase
{
    public function testGetByOrder(): void
    {
        $db = $this->getMockBuilder(\Db::class)
            ->disableOriginalConstructor()
            ->getMock();

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();
        $order->id = 1;

        $repository = new InvoiceAddressRepository($db);

        $db
            ->method('executeS')
            ->with(
                'SELECT o.id_order, a.* FROM `' . _DB_PREFIX_ . 'orders` o'
                . ' INNER JOIN `' . _DB_PREFIX_ . 'address` a ON a.id_address = o.id_address_invoice'
                . ' WHERE o.id_order IN (1)'
            )
            ->willReturn([
                [
                    'id_order' => 1,
                    'id_address' => 10,
                ],
            ]);

        // Preload objects
        $repository->preload([$order]);

        $address = $repository->getByOrder($order);

        self::assertEquals(10, $address->id);
    }
}
