<?php

namespace Unit\Accounting\Export\Exporter;

class OrderInvoiceExporterTest extends AbstractOrderInvoiceExporterTest
{
    public function fixtureProvider(): array
    {
        return [
            [
                [
                    'orderPayment' => ['amount' => 38.90, 'payment_method' => 'MyVetshop Paiements'],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 32.42,
                            'total_price_tax_incl' => 38.90,
                            'vat_amount' => 6.48,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-05-08 02:17:03',
                        'number' => 389444,
                        'shipping_tax_excl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '08/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 38.9,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 6.48,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '70711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 32.42,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.11,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.11,
                    ],
                ],
            ],
            [
                [
                    'orderPayment' => ['amount' => 94.60, 'payment_method' => 'MyVetshop Paiements'],
                    'orderDiscount' => ['total_tax_excl' => 5.08, 'total_tax_incl' => 6.09, 'vat_rate' => '20.000'],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 33.16,
                            'total_price_tax_incl' => 39.79,
                            'vat_amount' => 6.23,
                            'vat_rate' => '20.000',
                        ],
                        [
                            'total_price_tax_excl' => 50.75,
                            'total_price_tax_incl' => 60.9,
                            'vat_amount' => 9.54,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-05-08 09:06:58',
                        'number' => 389478,
                        'shipping_tax_excl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '08/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 94.6,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '7097',
                        'entitled' => 'Vente internet',
                        'debit' => 5.08,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 15.77,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '70711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 83.91,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.27,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.27,
                    ],
                ],
            ],
            [
                [
                    'orderPayment' => ['amount' => 102.69, 'payment_method' => 'MyVetshop Paiements'],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 71.58,
                            'total_price_tax_incl' => 85.89,
                            'vat_amount' => 14.31,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-05-09 13:56:53',
                        'number' => 390144,
                        'shipping_tax_excl' => 14.00,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '09/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 102.69,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 17.11,
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '70711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 71.58,
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '7080001',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 14,
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.3,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.3,
                    ],
                ],
            ],
            [
                [
                    'country' => 'CH',
                    'orderPayment' => ['amount' => 81.9, 'payment_method' => 'MyVetshop Paiements'],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 68.25,
                            'total_price_tax_incl' => 81.9,
                            'vat_amount' => 13.65,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-05-08 13:54:27',
                        'number' => 389630,
                        'shipping_tax_excl' => 0.00,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '08/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 81.9,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 13.65,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '70713',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 68.25,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.24,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.24,
                    ],
                ],
            ],
            [
                [
                    'orderPayment' => ['amount' => 102.08, 'payment_method' => 'MyVetshop Paiements'],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 25.49,
                            'total_price_tax_incl' => 30.59,
                            'vat_amount' => 5.1,
                            'vat_rate' => '20.000',
                        ],
                        [
                            'total_price_tax_excl' => 24.83,
                            'total_price_tax_incl' => 29.80,
                            'vat_amount' => 4.97,
                            'vat_rate' => '20.000',
                        ],
                        [
                            'total_price_tax_excl' => 34.75,
                            'total_price_tax_incl' => 34.75,
                            'vat_amount' => 6.95,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-01-01 11:05:39',
                        'number' => 340216,
                        'shipping_tax_excl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '01/01/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 102.08,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '01/01/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 17.01,
                    ],
                    [
                        'date' => '01/01/2023',
                        'account' => '70711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 85.07,
                    ],
                    [
                        'date' => '01/01/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.3,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '01/01/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.3,
                    ],
                ],
            ],
        ];
    }
}
