<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Vat;

/**
 * @template T of object
 */
interface VatExporterInterface
{
    /**
     * Return the amount of VAT by rate
     *
     * @param T $document
     *
     * @return array<numeric-string, float>
     *
     *@example {'20.000' => 15.0, '5.500' => 2.0}
     */
    public function getVatValues(object $document, \Order $order): array;
}
