<?php

namespace Unit\Accounting\Export\Exporter\Provider\Payment;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Payment\PaymentProvider;
use PHPUnit\Framework\TestCase;

class PaymentProviderTest extends TestCase
{
    protected PaymentProvider $paymentProvider;

    protected function setUp(): void
    {
        $this->paymentProvider = new PaymentProvider();
    }

    public function testGetInvoiceAccountingLines(): void
    {
        $orderInvoice = $this->getMockBuilder(\OrderInvoice::class)
            ->disableOriginalConstructor()
            ->getMock();
        $orderInvoice->total_paid_tax_incl = 100;

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();

        $lines = $this->paymentProvider->getInvoiceAccountingLines($orderInvoice, $order);

        self::assertCount(1, $lines);
        self::assertEquals('4110001', $lines[0]->getAccount());
        self::assertEquals(0.0, $lines[0]->getCredit());
        self::assertEquals(100, $lines[0]->getDebit());
    }
}
