<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\OrderInvoiceLineProviderInterface;

/**
 * @extends AbstractDocumentExporter<\OrderInvoice>
 */
class OrderInvoiceExporter extends AbstractDocumentExporter
{
    protected function getDocumentDate($document): \DateTimeImmutable
    {
        $invoiceDate = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', (string) $document->date_add);
        if (!$invoiceDate) {
            throw new \Exception('Invalid invoice date');
        }

        return $invoiceDate;
    }

    protected function getDocumentReference($document, \Order $order): string
    {
        return (string) $document->number;
    }

    /**
     * @param list<OrderInvoiceLineProviderInterface> $providers
     */
    public function __construct(
        array $providers
    ) {
        $this->providers = $providers;
        $this->entitled = 'Vente internet';
    }

    public function export($document, \Order $order): array
    {
        if ((int) $document->id_order !== (int) $order->id) {
            throw new \LogicException('OrderInvoice#' . $document->id . ' and Order#' . $order->id . " don't match");
        }

        return parent::export($document, $order); // TODO: Change the autogenerated stub
    }

    /*
        public function export(): array
        {
            return array_merge(
                $this->exportPaymentLines(),
                $this->exportDiscountLines(),
                $this->exportVatLines(),
                $this->exportProductLines(),
                $this->exportShippingLines(),
                $this->exportBankCommissionLines(),
            );
        }
    */
    public function supports($document): bool
    {
        return $document instanceof \OrderInvoice;
    }
}
