<?php

declare(strict_types=1);

class HTMLTemplateInvoice extends HTMLTemplateInvoiceCore
{
    /**
     * Returns the template's HTML footer.
     */
    public function getFooter(): string
    {
        \Module::getInstanceByName('myvetshopclinique');

        $shop_address = $this->getShopAddress();

        $id_shop = (int) $this->shop->id;

        $context = \Context::getContext();
        \assert(null !== $context);

        $freeText = (string) \Configuration::get('
            PS_INVOICE_FREE_TEXT',
            (int) $context->language->id,
            null,
            $id_shop,
            ''
        );
        $clinique = Clinique::getCliniqueByCarrierId((int) $this->order->id_carrier);
        if ($clinique) {
            $store = new Store($clinique->id_store, $context->language->id);
            $freeText = str_replace(
                [
                    '{clinique.store.name}',
                ],
                [
                    $store->name,
                ],
                $freeText
            );
        }

        $this->smarty->assign([
            'available_in_your_account' => $this->available_in_your_account,
            'shop_address' => $shop_address,
            'shop_fax' => \Configuration::get('PS_SHOP_FAX', null, null, $id_shop),
            'shop_phone' => \Configuration::get('PS_SHOP_PHONE', null, null, $id_shop),
            'shop_email' => \Configuration::get('PS_SHOP_EMAIL', null, null, $id_shop),
            'free_text' => $freeText,
        ]);

        return $this->smarty->fetch($this->getTemplate('footer'));
    }
}
