<?php

namespace Unit\Accounting\Export\Exporter;

class OrderSlipExporterTest extends AbstractOrderSlipExporterTest
{
    public function fixtureProvider(): array
    {
        return [
            [
                [
                    'orderPayment' => ['amount' => 53.91, 'payment_method' => 'MyVetshop Paiements'],
                    'orderDetails' => [
                        ['total_price_tax_excl' => 49.92, 'total_price_tax_incl' => 59.90, 'vat_rate' => '20.000'],
                    ],
                    'orderDiscount' => ['total_tax_excl' => 4.99, 'total_tax_incl' => 5.99, 'vat_rate' => '20.000'],
                    'orderSlip' => [
                        'date' => '2023-05-09 13:27:23',
                        'invoice_number' => 372078,
                        'number' => 5376,
                        'type' => 1,
                        'products_tax_incl' => 59.9,
                        'shipping_tax_excl' => 0.0,
                        'shipping_tax_incl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                    'orderSlipDetails' => [
                        ['product_quantity' => 1, 'amount_tax_excl' => 49.92, 'amount_tax_incl' => 59.90],
                    ],
                ],
                [
                    [
                        'date' => '09/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.0,
                        'credit' => 53.91,
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '7097',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.00,
                        'credit' => 4.99,
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '445711',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 8.98,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '70711',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 49.92,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '627',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.00,
                        'credit' => 0.16,
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.16,
                        'credit' => 0.00,
                    ],
                ],
            ],
            [
                [
                    'orderPayment' => ['amount' => 30.81, 'payment_method' => 'MyVetshop Paiements'],
                    'orderDetails' => [
                        ['total_price_tax_excl' => 16.59, 'total_price_tax_incl' => 19.89, 'vat_rate' => '20.000'],
                        ['total_price_tax_excl' => 12.42, 'total_price_tax_incl' => 14.90, 'vat_rate' => '20.000'],
                    ],
                    'orderSlip' => [
                        'date' => '2023-05-16 12:13:59',
                        'invoice_number' => 390823,
                        'number' => 5397,
                        'type' => 0,
                        'products_tax_incl' => 34.79,
                        'shipping_tax_excl' => 0.0,
                        'shipping_tax_incl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                    'orderSlipDetails' => [
                        ['product_quantity' => 1, 'amount_tax_excl' => 16.58, 'amount_tax_incl' => 19.89],
                        ['product_quantity' => 1, 'amount_tax_excl' => 12.42, 'amount_tax_incl' => 14.90],
                    ],
                ],
                [
                    [
                        'date' => '16/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.0,
                        'credit' => 34.79,
                    ],
                    [
                        'date' => '16/05/2023',
                        'account' => '445711',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 5.79,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '16/05/2023',
                        'account' => '70711',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 29,
                        'credit' => 0.00,
                    ],
                    [
                        'date' => '16/05/2023',
                        'account' => '627',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.00,
                        'credit' => 0.1,
                    ],
                    [
                        'date' => '16/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.1,
                        'credit' => 0.00,
                    ],
                ],
            ],
        ];
    }
}
