<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Discount;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\OrderInvoiceLineProviderInterface;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\OrderSlipLineProviderInterface;
use Myvetshop\Module\Clinique\Accounting\Export\Model\SimpleAccountingLine;

class DiscountProvider implements OrderInvoiceLineProviderInterface, OrderSlipLineProviderInterface
{
    public function getInvoiceAccountingLines(\OrderInvoice $orderInvoice, \Order $order): array
    {
        $ret = [];

        $totalDiscounts = \round($orderInvoice->total_discount_tax_excl, 2);

        if ($totalDiscounts > 0) {
            $ret[] = new SimpleAccountingLine(
                '7097',
                0.0,
                $totalDiscounts
            );
        }

        return $ret;
    }

    public function getSlipAccountingLines(\OrderSlip $orderSlip, \Order $order): array
    {
        $totalDiscounts = \round($order->total_discounts_tax_excl, 2);

        // Les réductions sont prises en compte uniquement sur un remboursement complet
        if (1 !== $orderSlip->order_slip_type || $totalDiscounts <= 0) {
            return [];
        }

        return [
            new SimpleAccountingLine(
                '7097',
                $totalDiscounts,
                0.00
            ),
        ];
    }

    /**
     * @param \OrderInvoice|\OrderSlip $document
     */
    public function getAccountingLines($document, \Order $order): array
    {
        return $document instanceof \OrderInvoice
            ? $this->getInvoiceAccountingLines($document, $order)
            : $this->getSlipAccountingLines($document, $order);
    }
}
