<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\BankCharge\Computer;

class BankChargeComputerFactory
{
    /**
     * @var array<string, BankChargeComputerInterface>
     */
    protected array $exporters;

    public function __construct()
    {
        $this->exporters = [
            'Chèque' => new CheckOrderPaymentExporter(),
            'Commande gratuite' => new FreeBankChargeComputer(),
            'CM-CIC' => new MoneticoBankChargeComputer(),
            'MyVetshop Paiements' => new MoneticoBankChargeComputer(),
            'Stripe' => new StripeBankChargeComputer(),
        ];
    }

    public function create(\OrderPayment $orderPayment): BankChargeComputerInterface
    {
        if (!isset($this->exporters[$orderPayment->payment_method])) {
            throw new \Exception(\sprintf('Unknown payment method : %s', $orderPayment->payment_method));
        }

        return $this->exporters[$orderPayment->payment_method];
    }
}
