<?php

namespace Unit\Serializer;

use Myvetshop\Module\Clinique\Serializer\ProductCategoryReportingSerializer;
use PHPUnit\Framework\TestCase;

class ProductCategoryReportingSerializerTest extends TestCase
{
    public function testSerialize(): void
    {
        self::assertSame(
            [
                [
                    'id' => 1,
                    'name' => 'Racine',
                    'id_parent' => 0,
                    'level_depth' => 0,
                    'active' => true,
                ],
            ],
            \json_decode(
                (new ProductCategoryReportingSerializer())->serialize([
                    [
                        'id' => '1',
                        'name' => 'Racine',
                        'id_parent' => '0',
                        'level_depth' => '0',
                        'active' => '1',
                    ],
                ]),
                true,
            )
        );
    }
}