<?php

namespace Unit\Serializer;

use Myvetshop\Module\Clinique\Serializer\ClinicReportingSerializer;
use PHPUnit\Framework\TestCase;

class ClinicReportingSerializerTest extends TestCase
{
    public function testSerialize(): void
    {
        self::assertSame(
            [
                [
                    'id' => 1,
                    'code_privilege' => 'CLM296',
                    'name' => 'Clinique vétérinaire CLM296',
                    'address1' => 'Inconnu',
                    'address2' => '',
                    'postcode' => '',
                    'city' => 'Paris',
                    'deleted' => false,
                ],
            ],
            \json_decode(
                (new ClinicReportingSerializer())->serialize([
                    [
                        'id' => '1',
                        'code_privilege' => 'CLM296',
                        'name' => 'Clinique vétérinaire CLM296',
                        'address1' => 'Inconnu',
                        'address2' => '',
                        'postcode' => '',
                        'city' => 'Paris',
                        'deleted' => '0',
                    ],
                ]),
                true,
            )
        );
    }
}