<?php

declare(strict_types=1);

// Si on est pas exécuté depuis la ligne de commande, on arrête tout !
if ('cli' != \PHP_SAPI) {
    exit(1);
}

// Désactivation du timeout
set_time_limit(0);

// ///////////////////////////////////////////////
// Configuration

// ///////////////////////////////////////////////
// Bootstrap PrestaShop
try {
    require_once __DIR__ . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . 'config' . \DIRECTORY_SEPARATOR . 'config.inc.php';
    require_once __DIR__ . \DIRECTORY_SEPARATOR . 'classes' . \DIRECTORY_SEPARATOR . 'OrderCorrector.php';

    // Gestion multi-boutique (au cas où) : Ce module est global
    if (Shop::isFeatureActive()) {
        Shop::setContext(Shop::CONTEXT_ALL);
    }

    global $kernel;
    if (!$kernel) {
        require_once _PS_ROOT_DIR_ . '/app/AppKernel.php';
        $kernel = new \AppKernel('prod', false);
        $kernel->boot();
    }
} catch (Exception $e) {
    echo $e->getMessage() . "\n" . $e->getTraceAsString();
    exit;
}

$context = Context::getContext();
$context->currency = new Currency(1);
$context->employee = new Employee(1);

// Workaround pour PrestaShop
$context->controller = (object) [
    'controller_type' => 'cron',
];

Module::getInstanceByName('myvetshopclinique');

$order = new Order(266556);
$order->setCurrentState(4, 1);
