<?php

declare(strict_types=1);

// Si on n'est pas exécuté depuis la ligne de commande, ou si la mauvaise secure_key est envoyée, on arrête tout !
if ('cli' != \PHP_SAPI) {
    exit(1);
}

// Désactivation du timeout
set_time_limit(0);

// ///////////////////////////////////////////////
// Configuration

// ///////////////////////////////////////////////
// Bootstrap PrestaShop
try {
    require_once __DIR__ . '/../../../config/config.inc.php';

    // Gestion multiboutique (au cas où) : Ce module est global
    if (Shop::isFeatureActive()) {
        Shop::setContext(Shop::CONTEXT_ALL);
    }
} catch (Exception $e) {
    echo $e->getMessage() . "\n" . $e->getTraceAsString();
    exit;
}

$context = Context::getContext();

// Workaround pour PrestaShop
// @phpstan-ignore-next-line
$context->controller = (object) [
    'controller_type' => 'cron',
    'php_self' => 'notif_globale',
];

\Module::getInstanceByName('myvetshopclinique');

$notificationManager = new NotificationManager();

$result = Db::getInstance()
    ->executeS('SELECT * FROM `ps_customer_push` WHERE `deleted` = 0 GROUP BY `push_id` ORDER BY `id_customer_push` DESC');

if (!is_array($result)) {
    $result = [];
}

/** @var CustomerPush[] $customerPushes */
$customerPushes = ObjectModel::hydrateCollection(
    CustomerPush::class, $result
);

foreach ($customerPushes as $customerPush) {
    echo $customerPush->push_id . "\n";
    try {
        $notificationManager->sendNotification($customerPush, "Une nouvelle version de l'application MyVetshop est disponible dans votre store. Bonne rentrée à toutes et à tous.🐶🐱");
    } catch (\Exception $exception) {
        // Inhibiteur d'erreur
        // var_dump($exception);
    }
}
