<?php

declare(strict_types=1);

class MyvetshopRecommandationProduct extends ObjectModel
{
    public $id_recommandation;

    public $id_product;

    public $id_recommandation_product_next;

    public $quantity;

    public $months;

    public static $definition = [
        'table' => 'recommandation_product',
        'primary' => 'id_recommandation_product',
        'fields' => [
            'id_recommandation' => ['type' => self::TYPE_INT],
            'id_product' => ['type' => self::TYPE_INT],
            'id_recommandation_product_next' => ['type' => self::TYPE_INT],
            'quantity' => ['type' => self::TYPE_INT],
            'months' => ['type' => self::TYPE_INT],
        ],
    ];

    public function isNextOf(int $recommandationProductId): bool
    {
        $recommandationProduct = new self($recommandationProductId);

        if (!Validate::isLoadedObject($recommandationProduct) || !$recommandationProduct->id_recommandation_product_next) {
            return false;
        }

        if ($recommandationProduct->id_recommandation_product_next == $this->id) {
            return true;
        }

        return $this->isNextOf($recommandationProduct->id_recommandation_product_next);
    }

    public function getPrevious(): ?self
    {
        $query = 'SELECT id_recommandation_product FROM ' . _DB_PREFIX_ . self::$definition['table'] . ' WHERE id_recommandation_product_next=' . $this->id;
        $recommandationProductId = Db::getInstance()->getValue($query);
        $recommandationProduct = new self($recommandationProductId);

        return Validate::isLoadedObject($recommandationProduct) ? $recommandationProduct : null;
    }

    public function getNext(): ?self
    {
        $recommandationProduct = new self($this->id_recommandation_product_next);

        return Validate::isLoadedObject($recommandationProduct) ? $recommandationProduct : null;
    }

    public function hasNext(): bool
    {
        return null !== $this->getNext();
    }

    public function getProduct(): Product
    {
        return new Product($this->id_product, false, Context::getContext()->language->id);
    }

    /**
     * @return MyvetshopRecommandationProduct[]
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public static function getByRecommandationId(int $recommandationId): array
    {
        $query = 'SELECT id_recommandation_product FROM ' . _DB_PREFIX_ . self::$definition['table'] . ' WHERE id_recommandation=' . $recommandationId;
        $list = array_column(Db::getInstance()->executeS($query), 'id_recommandation_product');

        return array_map(fn ($recommandationProductId) => new self($recommandationProductId), $list);
    }

    public static function install(): bool
    {
        $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . self::$definition['table'] . '` (
              `id_recommandation_product` INT(11) NOT NULL AUTO_INCREMENT,
              `id_recommandation` INT(11) NOT NULL,
              `id_product` INT(11) NOT NULL,
              `id_recommandation_product_next` INT(11) NULL,
              `quantity` INT(11) NOT NULL NULL,
              `months` INT(11) NULL,
               PRIMARY KEY (`id_recommandation_product`)
            );';

        return Db::getInstance()->execute($query);
    }
}
