<?php

declare(strict_types=1);

class CgvCustomer extends ObjectModel
{
    public const TABLE = 'myvetshop_cgv_customer';

    /**
     * @var int
     */
    public $id_myvetshop_cgv_customer;

    /**
     * @var int
     */
    public $id_customer;

    /**
     * @var int
     */
    public $id_cgv_accepte;

    /**
     * @var string Object creation date
     */
    public $date_acceptation;

    /**
     * @var string
     */
    public $ip_acceptation;

    /**
     * @var array<string, mixed>
     *
     * @see ObjectModel::$definition
     */
    public static $definition
        = [
            'table' => self::TABLE,
            'primary' => 'id_myvetshop_cgv_customer',
            'multilang' => false,
            'multilang_shop' => false,
            'fields' => [
                'id_customer' => ['type' => self::TYPE_INT],
                'id_cgv_accepte' => ['type' => self::TYPE_INT],
                'date_acceptation' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
                'ip_acceptation' => ['type' => self::TYPE_STRING],
            ],
        ];
}
