<?php

declare(strict_types=1);

class BuyLimitedNumberOfProducts extends ObjectModel
{
    public const TABLE = 'buy_limited_number_of_products';

    /**
     * @var int
     */
    public $id_product;

    /**
     * @var int
     */
    public $max_quantity;

    /**
     * @see ObjectModel::$definition
     *
     * @var array<string, mixed>
     */
    public static $definition = [
        'table' => self::TABLE,
        'primary' => 'id_product',
        'multilang' => false,
        'multilang_shop' => false,
        'fields' => [
            'max_quantity' => ['type' => self::TYPE_INT],
        ],
    ];

    public static function install(): bool
    {
        $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . static::TABLE . '` (
			  `id_product` INT(11) NOT NULL,
              `max_quantity` INT(11) NOT NULL,    
			   PRIMARY KEY (`id_product`)
			);';

        return Db::getInstance()->execute($query);
    }
}
