<?php

declare(strict_types=1);

require_once __DIR__ . DIRECTORY_SEPARATOR . 'ApiFrontController.php';
require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'CustomerPush.php';

class MyvetshopcliniqueNotificationsModuleFrontController extends ApiFrontController
{
    /**
     * @return array<string, mixed>
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function configureAction(): array
    {
        $customerPushRaw = Tools::getValue('config');

        if (!$customerPushRaw || !is_array($customerPushRaw) || !isset($customerPushRaw['id']) || !$customerPushRaw['id']) {
            return [];
        }

        $customerPush = new CustomerPush($customerPushRaw['id']);

        if ($customerPush->id_customer != $this->context->customer->id) {
            return [];
        }

        $customer = new Customer($customerPush->id_customer);

        if (isset($customerPushRaw['is_newsletter'])) {
            $customer->newsletter = 'true' == $customerPushRaw['is_newsletter'];
        } elseif (isset($customerPushRaw['is_lettre_information'])) {
            $customerPush->is_lettre_information = 'true' == $customerPushRaw['is_lettre_information'];
            $customer->newsletter = $customerPush->is_lettre_information;
        }
        if (isset($customerPushRaw['is_optin'])) {
            $customer->optin = 'true' == $customerPushRaw['is_optin'];
        }
        $customerPush->is_commande = 'true' == $customerPushRaw['is_commande'];
        $customerPush->is_promos = 'true' == $customerPushRaw['is_promos'];
        $customerPush->is_clinique = 'true' == $customerPushRaw['is_clinique'];
        $customerPush->is_animaux = 'true' == $customerPushRaw['is_animaux'];
        $customerPush->update();
        $customer->update();

        return [
            'id' => $customerPush->id_customer_push,
            'id_customer' => $customerPush->id_customer,
            'push_id' => $customerPush->push_id,
            'push_type' => $customerPush->push_type,
            'is_lettre_information' => boolval($customer->newsletter),
            'is_newsletter' => boolval($customer->newsletter),
            'is_optin' => boolval($customer->optin),
            'is_commande' => boolval($customerPush->is_commande),
            'is_promos' => boolval($customerPush->is_promos),
            'is_clinique' => boolval($customerPush->is_clinique),
            'is_animaux' => boolval($customerPush->is_animaux),
            'date_add' => date('Y-m-d H:i:s'),
            'date_upd' => date('Y-m-d H:i:s'),
        ];
    }

    /**
     * @return array<string, mixed>
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function registerAction(): array
    {
        $pushId = Tools::getValue('push_id');
        $pushType = Tools::getValue('push_type');

        if (!$pushId || !$pushType) {
            return [];
        }

        $idCustomerPush = CustomerPush::getByPushId($pushId);
        $customerPush = null;
        if (!$idCustomerPush) {
            $customerPush = new CustomerPush();
            $customerPush->push_id = $pushId;
            $customerPush->push_type = $pushType;
            $customerPush->id_customer = $this->context->customer->id;
            $customerPush->is_commande = true;
            $customerPush->is_clinique = true;
            // Indique quel AccessToken est utilisé
            if ($this->accessToken) {
                $customerPush->id_oauth_access_token = (int) $this->accessToken->id;
            }

            $customerPush->save();
        } else {
            $customerPush = new CustomerPush($idCustomerPush);
        }

        if ($this->accessToken && !$customerPush->id_oauth_access_token) {
            $customerPush->id_oauth_access_token = (int) $this->accessToken->id;
            $customerPush->save();
        }

        $customer = new Customer($customerPush->id_customer);

        return [
            'id' => $customerPush->id_customer_push,
            'id_customer' => $customerPush->id_customer,
            'push_id' => $customerPush->push_id,
            'push_type' => $customerPush->push_type,
            'is_lettre_information' => boolval($customer->newsletter),
            'is_newsletter' => boolval($customer->newsletter),
            'is_optin' => boolval($customer->optin),
            'is_commande' => boolval($customerPush->is_commande),
            'is_promos' => boolval($customerPush->is_promos),
            'is_clinique' => boolval($customerPush->is_clinique),
            'is_animaux' => boolval($customerPush->is_animaux),
            'date_add' => date('Y-m-d H:i:s'),
            'date_upd' => date('Y-m-d H:i:s'),
        ];
    }

    /**
     * @return array<string, string>|void
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     *
     * {@inheritDoc}
     */
    protected function unregisterAction()
    {
        $pushId = Tools::getValue('push_id');

        if (!$pushId) {
            header('HTTP/1.0 400 Bad Request');

            return [];
        }

        $idCustomerPush = CustomerPush::getByPushId($pushId);
        if (!$idCustomerPush) {
            // C'est un succès (code 200), juste rien à faire
            return ['error' => 'ID Push non trouvé'];
        }
        $customerPush = new CustomerPush($idCustomerPush);
        if ($customerPush->id_customer != $this->context->customer->id) {
            header('HTTP/1.0 403 Forbidden');

            return [];
        }

        // Supprime l'association
        $customerPush->delete();
    }

    /**
     * Assign template vars related to page content
     *
     * @see FrontController::initContent()
     */
    public function initContent(): void
    {
        parent::initContent();

        switch (Tools::getValue('action', 'nothing')) {
            case 'configure':
                $ret = $this->configureAction();
                break;

            case 'register':
                $ret = $this->registerAction();
                break;

            case 'unregister':
                $ret = $this->unregisterAction();
                break;

            default:
                $ret = [];
        }

        echo json_encode($ret, JSON_PRETTY_PRINT);
        exit();
    }
}
