<?php

declare(strict_types=1);

class Cgv extends ObjectModel
{
    public const TABLE = 'myvetshop_cgv';

    /**
     * @var int
     */
    public $id_myvetshop_cgv;

    /**
     * @var string
     */
    public $version;

    /**
     * @var string
     */
    public $texte;

    /**
     * @var string Object creation date
     */
    public $date_add;

    /**
     * @var string Object last modification date
     */
    public $date_upd;

    /**
     * @var array<string, mixed>
     *
     * @see ObjectModel::$definition
     */
    public static $definition
        = [
            'table' => self::TABLE,
            'primary' => 'id_myvetshop_cgv',
            'multilang' => false,
            'multilang_shop' => false,
            'fields' => [
                'version' => ['type' => self::TYPE_STRING],
                'texte' => ['type' => self::TYPE_STRING],
                'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
                'date_upd' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
            ],
        ];
}
