<?php

declare(strict_types=1);

class MyvetshopTheme extends ObjectModel
{
    /**
     * @var string
     */
    public $name;

    /**
     * @var string
     */
    public $color_1;

    /**
     * @var string
     */
    public $color_2;

    /**
     * @var string
     */
    public $color_3;

    /**
     * @var string
     */
    public $color_4;

    /**
     * @var string
     */
    public $color_5;

    /**
     * @var array<string, mixed>
     */
    public static $definition = [
        'table' => 'myvetshop_theme',
        'primary' => 'id_myvetshop_theme',
        'fields' => [
            'name' => ['type' => self::TYPE_STRING, 'required' => true],
            'color_1' => ['type' => self::TYPE_STRING, 'required' => true, 'validate' => 'isColor'],
            'color_2' => ['type' => self::TYPE_STRING, 'required' => true, 'validate' => 'isColor'],
            'color_3' => ['type' => self::TYPE_STRING, 'required' => true, 'validate' => 'isColor'],
            'color_4' => ['type' => self::TYPE_STRING, 'required' => true, 'validate' => 'isColor'],
            'color_5' => ['type' => self::TYPE_STRING, 'required' => true, 'validate' => 'isColor'],
        ],
    ];

    public function getFilename(): string
    {
        return 'theme_privilege_' . $this->id . '.css';
    }

    /**
     * @return MyvetshopTheme[]
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public static function getAll(): array
    {
        $query = new DbQuery();
        $query
            ->from(static::$definition['table']);

        $result = Db::getInstance()->executeS($query);

        if (!is_array($result)) {
            $result = [];
        }

        return ObjectModel::hydrateCollection(self::class, $result);
    }

    public static function install(): bool
    {
        $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . static::$definition['table'] . '` (
			  `id_myvetshop_theme` INT(11) NOT NULL AUTO_INCREMENT,
              `name` VARCHAR(128) NOT NULL,
              `color_1` VARCHAR(7) NOT NULL,
              `color_2` VARCHAR(7) NOT NULL,                    
              `color_3` VARCHAR(7) NOT NULL,                    
              `color_4` VARCHAR(7) NOT NULL,                    
              `color_5` VARCHAR(7) NOT NULL,                    
			   PRIMARY KEY (`id_myvetshop_theme`)
			);';

        return Db::getInstance()->execute($query);
    }
}
