<?php
/**
 * Created by PhpStorm.
 * User: Julien
 * Date: 28/05/2020
 * Time: 09:21
 */
require_once __DIR__ . '/../../../config/config.inc.php';
require_once __DIR__ . '/../classes/OAuthAccessToken.php';
require_once __DIR__ . '/../classes/AppWebserviceRequest.php';

require_once __DIR__ . '/Service/HideString.php';
require_once __DIR__ . '/Service/AccessChecker.php';
require_once __DIR__ . '/Service/UserProvider.php';

require_once __DIR__ . '/Exceptions/MvsBadRequestException.php';
require_once __DIR__ . '/Exceptions/MvsUnauthorizedException.php';

require_once __DIR__ . '/Router.php';

require_once 'Controller/CustomersController.php';
//https://dev.myvetshop.fr/modules/myvetshopclinique/api_pps/

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

try {
    $router = new Router();
    echo json_encode($router->start());
} catch (Exception $exception) {
    if ($exception->getCode()) {
        http_response_code($exception->getCode());
    } else {
        http_response_code(500);
    }
    echo json_encode(['error' => $exception->getMessage()]);
}
exit();
