<?php

require_once __DIR__ . '/OrderProblemInterface.php';

class OrderProblemInvoice implements OrderProblemInterface
{
    /**
     * @var Order
     */
    protected $order;

    /**
     * @var OrderInvoice[]
     */
    protected $orderInvoices = [];

    /**
     * @var string[];
     */
    protected $errors;

    /**
     * @var bool
     */
    protected $repairable;

    /**
     * @param bool $repairable
     *
     * @return string[]
     */
    protected function computeErrors(&$repairable): array
    {
        $ret = [];
        $repairable = true;

        // On ne traite pas le cas de plus de 1 facture pour 1 commande
        if (count($this->orderInvoices) > 1) {
            return [];
        }
        $invoice = $this->orderInvoices[0];

        if ($invoice->total_products != $this->order->total_products) {
            $ret[] = 'Facture : i.total_products != o.total_products';
        }
        if ($invoice->total_products_wt != $this->order->total_products_wt) {
            $ret[] = 'Facture : i.total_products_wt != o.total_products_wt';
        }
        if ($invoice->total_shipping_tax_excl != $this->order->total_shipping_tax_excl) {
            $ret[] = 'Facture : i.total_shipping_tax_excl != o.total_shipping_tax_excl';
        }
        if ($invoice->total_shipping_tax_incl != $this->order->total_shipping_tax_incl) {
            $ret[] = 'Facture : i.total_shipping_tax_incl != o.total_shipping_tax_incl';
        }
        if ($invoice->total_paid_tax_excl != $this->order->total_paid_tax_excl) {
            $ret[] = 'Facture : i.total_paid_tax_excl != o.total_paid_tax_excl';
        }
        if ($invoice->total_paid_tax_incl != $this->order->total_paid_tax_incl) {
            $ret[] = 'Facture : i.total_paid_tax_incl != o.total_paid_tax_incl';
        }

        return $ret;
    }

    public function __construct(Order $order)
    {
        $this->order = $order;
        $this->orderInvoices = $order->getInvoicesCollection();
        $this->errors = $this->computeErrors($this->repairable);
    }

    public function getErrorMessage(): string
    {
        return "La facture n'est pas en accord avec la commande";
    }

    /**
     * @return string[]
     */
    public function getErrors(): array
    {
        return $this->errors;
    }

    public function isProblematic(): bool
    {
        return count($this->errors) > 0;
    }

    public function isRepairable(): bool
    {
        return $this->isProblematic();
    }

    public function repair(): bool
    {
        if (!$this->isRepairable()) {
            return false;
        }

        $invoice = $this->orderInvoices[0];

        $invoice->total_products = $this->order->total_products;
        $invoice->total_products_wt = $this->order->total_products_wt;
        $invoice->total_shipping_tax_excl = $this->order->total_shipping_tax_excl;
        $invoice->total_shipping_tax_incl = $this->order->total_shipping_tax_incl;
        $invoice->total_paid_tax_excl = $this->order->total_paid_tax_excl;
        $invoice->total_paid_tax_incl = $this->order->total_paid_tax_incl;

        $invoice->save();

        return true;
    }
}
