<?php

class MyvetshopVeterinaire extends ObjectModel
{
    public const TABLE = 'myvetshop_veterinaire';

    public $id_myvetshop_clinique;

    public $lastname;

    public $firstname;

    public $url_teleconsultation;

    public static $definition = [
        'table' => self::TABLE,
        'primary' => 'id_myvetshop_veterinaire',
        'fields' => [
            'id_myvetshop_clinique' => ['type' => self::TYPE_INT, 'required' => true, 'validate' => 'isInt'],
            'lastname' => ['type' => self::TYPE_STRING, 'required' => false, 'size' => 55],
            'firstname' => ['type' => self::TYPE_STRING, 'required' => false, 'size' => 55],
            'url_teleconsultation' => ['type' => self::TYPE_STRING, 'required' => false, 'size' => 100],
        ],
    ];

    public function getClinique(): Clinique
    {
        return new Clinique($this->id_myvetshop_clinique);
    }

    public function toArray(): array
    {
        return [
            'nom' => $this->lastname,
            'prenom' => $this->firstname,
            'url_rdv' => $this->url_teleconsultation,
        ];
    }

    /**
     * @param int $cliniqueId
     *
     * @return MyvetshopVeterinaire[]
     */
    public static function getByCliniqueId(int $cliniqueId): array
    {
        $query = 'SELECT id_myvetshop_veterinaire FROM ' . _DB_PREFIX_ . self::$definition['table'] . ' WHERE id_myvetshop_clinique=' . $cliniqueId;

        $list = array_column(Db::getInstance()->executeS($query), 'id_myvetshop_veterinaire');

        return array_map(function ($veterinaireId) {
            return new MyvetshopVeterinaire($veterinaireId);
        }, $list);
    }

    public static function install(): bool
    {
        $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . static::TABLE . '` (
			  `id_myvetshop_veterinaire` INT(11) NOT NULL AUTO_INCREMENT,
			  `id_myvetshop_clinique` INT(11) NOT NULL,			 
              `lastname` varchar(55) DEFAULT NULL,
              `firstname` varchar(55) DEFAULT NULL,
              `url_teleconsultation` varchar(100) DEFAULT NULL,  
			   PRIMARY KEY (`id_myvetshop_veterinaire`),
			   INDEX (`id_myvetshop_clinique`)
			);';

        return Db::getInstance()->execute($query);
    }
}
