<?php

namespace Myvetshop\Module\Clinique\Builder;

use Clinique;
use MyvetshopCliniqueShipping;
use PrestaShop\PrestaShop\Adapter\Validate;

class ShippingBuilder
{
    public static function getShippingText(Clinique $clinique): string
    {
        if (!Validate::isLoadedObject($clinique) || $clinique->getShipping()->hasAllDaysDisable()) {
            return 'Livraison en 2 à 4 jours ouvrés (hors corse)';
        }

        $cliniqueShipping = $clinique->getShipping();

        $days = [];

        foreach ($cliniqueShipping->toArray() as $day => $value) {
            if ((int) $value) {
                $days[] = MyvetshopCliniqueShipping::getDay($day);
            }
        }

        if (1 == count($days)) {
            return 'Livraison le ' . end($days);
        }

        return 'Livraison le ' . implode(', le ', array_slice($days, 0, -1)) . ' et le ' . end($days);
    }
}
