{assign var='cartRule' value=$recommandation->getCartRule()}
<form id="form-reco-{$recommandation->id}"
      action="{$link->getModuleLink('myvetshopclinique', 'myreco', ['action' => 'update', 'id_recommandation' => $recommandation->id], true)|escape:'html'}"
      method="post">
    <div class="box">
        <h1>Pour le {$recommandation->getAnimal()->espece} {$recommandation->getAnimal()->nom}</h1>
        <br>
        <table class="table table-bordered">
            <tr>
                <th>Code RECO</th>
                <td>{$recommandation->code_reco}</td>
            </tr>
            <tr>
                <th>Date d'édition</th>
                <td>{$recommandation->date_reco|date_format:"%d/%m/%Y"}</td>
            </tr>
            <tr>
                <th>Fiche animal associée</th>
                <td>
                    <div class="row" style="padding-right: 5px;">
                        <div class="col-sm-7" style="padding: 8px">
                            <select id="reco-{$recommandation->id}-animal" name="id_animal"
                                    style="vertical-align: middle; width: 100%">
                                {foreach $animals as $animal}
                                    {if $animal->espece == $recommandation->getAnimal()->espece}
                                        <option {if $animal->id === $recommandation->getAnimal()->id}selected=selected{/if}
                                                value="{$animal->id}">{$animal->nom}</option>
                                    {/if}
                                {/foreach}
                            </select>
                        </div>
                        <div class="col-sm-4" style="padding: 8px;">
                            <a
                                    href="{$link->getModuleLink('myvetshopclinique', 'myanimal', ['id_animal' => $animal->id ])|escape:'htmlall':'UTF-8'}"
                                    class="btn btn-default button button-small"> <span> <i
                                            class="icon-paw"></i> Fiche Animal </span>
                            </a>
                        </div>
                    </div>

                </td>
            </tr>
            <tr>
                <th>Bon de réduction</th>
                <td>
                    {if $cartRule->code && $cartRule->quantity > 0 && $cartRule->active == 1 }
                        Code réduction :
                        <strong>{$cartRule->code}</strong>
                    {else}
                        Aucun bon de réduction
                    {/if}
                </td>
            </tr>
            <tr>
                <th>Consulter</th>
                <td>
                    <a target="_blank"
                       href="{$link->getModuleLink('myvetshopclinique', 'myreco')|escape:'htmlall':'UTF-8'}?action=pdf&id_reco={$recommandation->id}"
                       class="btn btn-default button button-small">
                            <span>
                                <i class="icon-file-pdf-o"></i>
                                PDF
                            </span>
                    </a>
                </td>
            </tr>
        </table>
        <h2>Produit(s)</h2>
        <br>

        {include file='module:myvetshopclinique/views/templates/front/myreco/_partials/_table_reco.tpl'}

        <div>
            <p style="text-align: end"> * veuillez <a target="_blank"
                                                      href="{$link->getModuleLink('myvetshopclinique', 'myreco', ['action' => 'pdf', 'id_recommandation' => $recommandation->id])|escape:'htmlall':'UTF-8'}"
                                                      style="text-decoration: underline">consuler
                    le
                    PDF</a>
                pour le détail des
                quantités journalières en fonction de l'âge de votre animal</p>
        </div>
        <ul class="footer_links" style="margin-top: 12px; border: 0">
            <li>
                <a class="btn btn-default button button-small" data-toggle="modal"
                        data-target="#modal-delete-reco-{$recommandation->id}" title="Supprimer">
                    <span>Supprimer <i class="icon-remove"></i></span>
                </a>

                <!-- Modal -->
                <div class="modal fade" id="modal-delete-reco-{$recommandation->id}" tabindex="-1"
                     role="dialog" aria-labelledby="modal-delete-reco-{$recommandation->id}-label">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close close-modal" data-dismiss="modal"
                                        aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="modal-delete-reco-{$recommandation->id}-label">
                                    Voulez-vous vraiment supprimer cette recommandation ?</h4>
                            </div>
                            <div class="modal-footer" style="border-top: 0">
                                <button type="button" class="close-modal btn btn-default"
                                        data-dismiss="modal">Annuler
                                </button>
                                <a type="button"
                                   href="{$link->getModuleLink('myvetshopclinique', 'myreco', ['action' => 'delete', 'id_recommandation' => $recommandation->id], true)|escape:'html'}"
                                   class="btn btn-danger">Supprimer</a>
                            </div>
                        </div>
                    </div>
                </div>

            </li>
            <li>
                <button class="btn btn-default button button-small" type="submit" title="Mettre à jour">
                    <span>Mettre à jour <i class="icon-chevron-right"></i></span>
                </button>
            </li>
        </ul>
    </div>
</form>