<?php

// Si on est pas exécuté depuis la ligne de commande, on arrête tout !
if ('cli' != php_sapi_name()) {
    die(1);
}

// Désactivation du timeout
set_time_limit(0);

/////////////////////////////////////////////////
// Configuration

/////////////////////////////////////////////////
// Bootstrap PrestaShop
try {
    require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'config.inc.php';
    require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'OrderCorrector.php';

    // Gestion multi-boutique (au cas où) : Ce module est global
    if (Shop::isFeatureActive()) {
        Shop::setContext(Shop::CONTEXT_ALL);
    }
} catch (Exception $e) {
    echo $e->getMessage() . "\n" . $e->getTraceAsString();
    exit();
}

$context = Context::getContext();

// Workaround pour PrestaShop
$context->controller = (object) [
    'controller_type' => 'cron',
];

Module::getInstanceByName('myvetshopclinique');

if ($argc > 1) {
    foreach (array_slice($argv, 1) as $idOrder) {
        echo 'Vérification de la commande ' . $idOrder;
        $order = new Order($idOrder);
        $orderCorrector = new OrderCorrector($order);

        if (!$orderCorrector->isCoherent()) {
            echo " FAIL\n";
        } else {
            echo " OK\n";
            break;
        }

        echo "\t - Problèmes détectés :\n";
        foreach ($orderCorrector->getProblems() as $problem) {
            echo "\t\t - " . $problem . "\n";
        }

        if ($orderCorrector->isRepairable()) {
            echo "\t - Certains problèmes peuvent être réparés\n";

            $orderCorrector->repair();

            echo "\t - Réparations exécutées\n";
        } else {
            echo "\t - Aucune réparation possible\n";
        }
    }

    Cache::getInstance()->delete('*');
    exit();
}
