<?php

class Router
{
    const SUPER_ADMIN_ID = 1;

    /**
     * @var AccessChecker
     */
    protected $accessChecker;
    /**
     * @var UserProvider
     */
    protected $userProvider;

    /**
     * @var string|null
     */
    protected $controller = null;

    /**
     * @var string|null
     */
    protected $action = null;

    /**
     * @var int|null
     */
    protected $idRessource = null;

    public function __construct()
    {
        $this->accessChecker = new AccessChecker();
        $this->userProvider = new UserProvider();
    }

    /**
     * @return array|string[]|void
     *
     * @throws MvsBadRequestException
     * @throws MvsUnauthorizedException
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function start()
    {
        $this->controller = Tools::getValue('controleur');
        $this->action = Tools::getValue('action');
        $this->idRessource = (int) Tools::getValue('id');

        $headers = getallheaders();
        $accessToken = $this->accessChecker->check($headers);
        $user = $this->userProvider->getUser($accessToken);

        if ($user instanceof Employee) {
            $clinique = Clinique::getCliniqueByEmployeeId((int) $accessToken->id_employee);

            $employeeIsSuperAdmin = false;
            if (self::SUPER_ADMIN_ID == $user->id_profile) {
                $employeeIsSuperAdmin = true;
            }

            if ($clinique->id || $employeeIsSuperAdmin) {
                return $this->routingClinique($clinique, $employeeIsSuperAdmin);
            }
        } elseif ($user instanceof Customer) {
            return $this->routingCustomer($user);
        }

        throw new MvsUnauthorizedException();
    }

    /**
     * @param Clinique $clinique
     * @param bool $employeeIsSuperAdmin
     *
     * @return array|string[]|void
     *
     * @throws MvsBadRequestException
     */
    protected function routingClinique(Clinique $clinique, bool $employeeIsSuperAdmin)
    {
        if ('customers' === $this->controller) {
            if ('GET' === $_SERVER['REQUEST_METHOD']) {
                $controller = new CustomersController($clinique, new HideString(), $employeeIsSuperAdmin);

                if ('search' === $this->action) {
                    if ('email' === Tools::getValue('filter') && Tools::getValue('value')) {
                        return $controller->searchCustomerWithfilter('email', Tools::getValue('value'));
                    }
                    if ('phone' === Tools::getValue('filter') && Tools::getValue('value')) {
                        return $controller->searchCustomerWithfilter('phone', Tools::getValue('value'));
                    }
                    if ('name' === Tools::getValue('filter') && Tools::getValue('value')) {
                        return $controller->searchCustomerWithfilter('name', Tools::getValue('value'));
                    }
                }
                if ('show' === $this->action && $this->idRessource) {
                    return $controller->getCustomers($this->idRessource);
                }
                if ('orders' === $this->action && $this->idRessource) {
                    return $controller->getLastOrders($this->idRessource);
                }
            }
        }

        throw new MvsBadRequestException();
    }

    /**
     * @param Customer $customer
     *
     * @return array|mixed
     *
     * @throws MvsBadRequestException
     * @throws PpsBadRequestException
     * @throws PpsNotFoundException
     * @throws PpsUnauthorizedException
     */
    protected function routingCustomer(Customer $customer)
    {
        if ('pps' === $this->controller) {
            if ('GET' === $_SERVER['REQUEST_METHOD']) {
                $controller = new PpsApiController();

                // /modules/myvetshopclinique/api_pps/pps/gecontracts/
                if ('getcontracts' === $this->action) {
                    return $controller->getContractsByCustomersEmail($customer->email);
                }

                // /modules/myvetshopclinique/api_pps/getacts/{idcontract}
                if ('getacts' === $this->action && $this->idRessource) {
                    return $controller->getActsByContractId($customer->email, $this->idRessource);
                }
            }
        }

        throw new MvsBadRequestException();
    }
}
