<?php

declare(strict_types=1);

use Myvetshop\Module\Clinique\Form\AnimalForm;
use Myvetshop\Module\Clinique\Formatter\AnimalFormatter;
use Myvetshop\Module\Clinique\Persister\AnimalPersister;

class MyvetshopcliniqueMyAnimalModuleFrontController extends ModuleFrontController
{
    private $animal;

    public function __construct()
    {
        parent::__construct();

        $animalId = Tools::getValue('id_animal');

        $animal = new Animal($animalId);

        if (Validate::isLoadedObject($animal)) {
            $this->animal = $animal;

            if ($this->animal->deleted || !$this->animal->hasCustomer((int) $this->context->customer->id)) {
                $this->redirectWithNotifications($this->context->link->getModuleLink($this->module->name, 'myanimals'));
            }
        }
    }

    /**
     * @throws PrestaShopException
     */
    public function initContent(): void
    {
        parent::initContent();

        $redirect = false;

        $formatter = new AnimalFormatter($this->translator);
        $persister = new AnimalPersister($this->context->customer, Tools::getToken(true, $this->context));
        $form = new AnimalForm($this->context->smarty, $this->translator, $formatter, $persister);

        $form->setAction($this->getCurrentURL());

        if (Tools::getIsset('submitCreate')) {
            $form->fillWith(Tools::getAllValues());

            if ($form->submit()) {
                if (!$this->animal) {
                    $this->success[] = $this->trans('L\'animal a été supprimé avec succès.', [], 'Modules.Myvetshopclinique.Shop');
                } else {
                    $this->success[] = $this->trans('L\'animal a été mis à jour avec succès.', [], 'Modules.Myvetshopclinique.Shop');
                }

                $redirect = true;
            } else {
                $this->errors[] = $this->trans('Could not update your information, please check your data.', [], 'Shop.Notifications.Error');
            }
        } elseif ($this->animal) {
            $form->fillWith(get_object_vars($this->animal));
        }

        if (Tools::getIsset('delete') && Tools::getValue('delete') && $this->animal) {
            if ($persister->delete($this->animal)) {
                $this->success[] = $this->trans('L\'animal a été supprimé avec succès.', [], 'Modules.Myvetshopclinique.Shop');
            } else {
                $this->errors[] = $this->trans('La suppression de l\'animal a échoué.', [], 'Modules.Myvetshopclinique.Shop');
            }

            $redirect = true;
        }

        if ($redirect) {
            $this->redirectWithNotifications($this->context->link->getModuleLink($this->module->name, 'myanimals'));
        }

        $this->context->smarty->assign('animal_form', $form->getProxy());

        $this->setTemplate('module:myvetshopclinique/views/templates/front/animal/my_animal.tpl');
    }

    protected function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();

        $breadcrumb['links'][] = [
            'title' => $this->trans('My account', [], 'Shop.Navigation'),
            'url' => $this->context->link->getPageLink('my-account'),
        ];

        $breadcrumb['links'][] = [
            'title' => $this->trans('Mes animaux', [], 'Modules.Myvetshopclinique.Shop'),
            'url' => $this->context->link->getModuleLink($this->module->name, 'myanimals'),
        ];

        if ($this->animal) {
            $title = $this->trans('Modifier %animal_name%', ['%animal_name%' => $this->animal->nom], 'Modules.Myvetshopclinique.Shop');
        } else {
            $title = $this->trans('Ajouter un animal', [], 'Modules.Myvetshopclinique.Shop');
        }

        $breadcrumb['links'][] = [
            'title' => $title,
            'url' => $this->getCurrentURL(),
        ];

        return $breadcrumb;
    }
}
