<?php

declare(strict_types=1);

/**
 * Created by Aurélien RICHAUD (01/08/2019 12:16)
 */
require_once __DIR__ . DIRECTORY_SEPARATOR . 'ApiFrontController.php';
require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'Clinique.php';
require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'OAuthAccessToken.php';

class MyvetshopcliniqueAccountModuleFrontController extends ApiFrontController
{
    /**
     * @return array<string, mixed>
     */
    protected function serializeCustomer(Customer $customer): array
    {
        return [
            'id' => $customer->id,
            'id_default_group' => $customer->id_default_group,
            'id_lang' => $customer->id_lang,
            'newsletter_date_add' => $customer->newsletter_date_add,
            'ip_registration_newsletter' => $customer->ip_registration_newsletter,
            'last_passwd_gen' => $customer->last_passwd_gen,
            'deleted' => $customer->deleted,
            'lastname' => $customer->lastname,
            'firstname' => $customer->firstname,
            'email' => $customer->email,
            'id_gender' => $customer->id_gender,
            'birthday' => $customer->birthday,
            'newsletter' => $customer->newsletter,
            'optin' => $customer->optin,
            'website' => $customer->website,
            'company' => $customer->company,
            'siret' => $customer->siret,
            'ape' => $customer->ape,
            'outstanding_allow_amount' => $customer->outstanding_allow_amount,
            'show_public_prices' => $customer->show_public_prices,
            'id_risk' => $customer->id_risk,
            'max_payment_days' => $customer->max_payment_days,
            'active' => $customer->active,
            'note' => $customer->note,
            'is_guest' => $customer->is_guest,
            'id_shop' => $customer->id_shop,
            'id_shop_group' => $customer->id_shop_group,
            'date_add' => $customer->date_add,
            'date_upd' => $customer->date_upd,
        ];
    }

    /**
     * @return array<string, mixed>
     *
     * @throws PrestaShopException
     */
    protected function actionPersonal(): array
    {
        if ('POST' == $_SERVER['REQUEST_METHOD']) {
            $customerRaw = Tools::getValue('customer');
            if (is_array($customerRaw) && isset($customerRaw['id']) && $customerRaw['id'] == $this->context->customer->id) {
                $this->context->customer->id_gender = $customerRaw['id_gender'];
                $this->context->customer->firstname = $customerRaw['firstname'];
                $this->context->customer->lastname = $customerRaw['lastname'];
                // TODO : Sécuriser le changement d'e-mail
                //$this->context->customer->email = $customerRaw['email'];
                $birthday = date_parse($customerRaw['birthday']);
                if ($birthday) {
                    $this->context->customer->birthday = $birthday['year'] . '-' . $birthday['month'] . '-' . $birthday['day'];
                }

                $this->context->customer->save();
            }
        }

        return $this->serializeCustomer($this->context->customer);
    }

    /**
     * Assign template vars related to page content
     *
     * @see FrontController::initContent()
     */
    public function initContent(): void
    {
        parent::initContent();

        switch (Tools::getValue('action', 'nothing')) {
            case 'personal':
                $ret = $this->actionPersonal();
                break;

            default:
                $ret = [];
        }

        echo json_encode($ret, JSON_PRETTY_PRINT);
        exit();
    }
}
