<?php

class CartController extends CartControllerCore
{
    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function processChangeProductInCart(): void
    {
        require_once _PS_MODULE_DIR_ . 'myvetshopclinique' . DIRECTORY_SEPARATOR . 'class' . DIRECTORY_SEPARATOR . 'LimitedNumberOfProductByOrder.php';

        $price = Product::getPriceStatic(
            (int) $this->id_product,
            false,
            (int) $this->id_product_attribute,
            6,
            null,
            false
        );

        if ($price <= 0.05) {
            $this->errors[] = Tools::displayError(
                "Ce produit n'est pas disponible car son prix présente une erreur. Vous ne pouvez pas le commander actuellement.",
                !Tools::getValue('ajax')
            );
        }

        // Limite la quantité d'un produit dans le panier

        $product = new Product((int) Tools::getValue('id_product'));
        $quantity = (int) Tools::getValue('qty');
        $op = Tools::getValue('op', 'up');

        if ('up' === $op && $product->id) {
            if (!LimitedNumberOfProductByOrder::canBuyProduct($this->context->cart, $product, $quantity)) {
                $this->errors[] = Tools::displayError(
                   'Impossible d’ajouter cette référence dans votre panier.',
                    !Tools::getValue('ajax')
                );
            }
        }

        /**
         * Empêche l'ajout des produits dont les achats sont restreints
         */
        $product = new Product($this->id_product, true, $this->context->language->id);
        /* @phpstan-ignore-next-line overide méthode non dispo dans le code source prestashop */
        if (!$product->canUserBuy($this->context->customer)) {
            /* @phpstan-ignore-next-line overide méthode non dispo dans le code source prestashop */
            switch ($product->getVenteRestreinte()) {
                case 'dietetique':
                    $this->errors[] = Tools::displayError(
                        "Merci d'avoir voulu commander ce produit.<br><br>Pour toute commande de produit diététique, <br>vous devez avoir un code privilège composé <br>de 3 lettres et 3 chiffres, fourni par votre vétérinaire.<br><br>Pour pouvoir compléter cette information, <br>veuillez cliquer sur le bouton « Mon compte » <br>ci-dessous ou aller vers « Nos vétérinaires »",
                        !Tools::getValue('ajax')
                    );
                    break;

                case 'rurale':
                    $this->errors[] = Tools::displayError(
                        "Merci d'avoir voulu commander ce produit.<br><br>Pour toute commande de produit rural, <br>vous devez avoir un code privilège composé <br>de 3 lettres et 3 chiffres, fourni par votre vétérinaire et que votre clinique autorise la vente de tels produits.<br><br>Pour pouvoir compléter cette information, <br>veuillez cliquer sur le bouton « Mon compte » <br>ci-dessous ou aller vers « Nos vétérinaires »",
                        !Tools::getValue('ajax')
                    );
                    break;

                default:
                    // Vente non restreinte
                    $this->errors[] = Tools::displayError(
                        "Merci d'avoir voulu commander ce produit.<br><br>Ce produit n'est pas disponible à la vente sans code privilège et si votre clinique n'a pas donné l'autorisation.<br><br>Pour pouvoir compléter cette information, <br>veuillez cliquer sur le bouton « Mon compte » <br>ci-dessous ou aller vers « Nos vétérinaires »",
                        !Tools::getValue('ajax')
                    );
            }
        }

        if (!$product->id || !$product->active || !$product->checkAccess($this->context->cart->id_customer)) {
            $this->errors[] = $this->trans(
                'This product is no longer available.', [],
                'Shop.Notifications.Error'
            );

            return;
        }

        if (0 == count($this->errors)) {
            parent::processChangeProductInCart();
        }
    }
}
