<?php

declare(strict_types=1);

/**
 * Created by Aurélien RICHAUD (23/05/2018 15:20)
 */
class Customer extends CustomerCore
{
    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function __construct($id = null)
    {
        parent::__construct($id);

        $this->webserviceParameters =
            [
                'fields' => [
                    'id_default_group' => ['setter' => null],
                    'id_lang' => ['setter' => null],
                    'newsletter_date_add' => [],
                    'ip_registration_newsletter' => [],
                    'last_passwd_gen' => ['setter' => null],
                    'secure_key' => ['setter' => null],
                    'deleted' => [],
                    'passwd' => ['setter' => 'setWsPasswd'],
                ],
                'associations' => [
                    'groups' => ['resource' => 'group'],
                    'animals' => ['resource' => 'animals', 'setter' => false, 'virtual_entity' => true,
                        'fields' => [
                            'id' => ['setter' => null],
                            'id_animal' => ['setter' => null],
                            'id_product' => ['setter' => null],
                            'id_customer' => ['setter' => null],
                            'espece' => ['setter' => null],
                            'nom' => ['setter' => null],
                            'race' => ['setter' => null],
                            'id_gender' => ['setter' => null],
                            'robe' => ['setter' => null],
                            'date_naissance' => ['setter' => null],
                            'ration' => ['setter' => null],
                            'photo' => ['setter' => null],
                        ],
                    ],
                ],
            ];
    }

    /**
     * @return array<string, mixed>
     *
     * @throws PrestaShopDatabaseException
     */
    public function getWsAnimals(): array
    {
        $query = '
        SELECT * FROM `' . _DB_PREFIX_ . 'animal` AS animal
        WHERE id_customer = ' . (int) $this->id . ' 
        AND animal.deleted = 0
        ';

        $results = Db::getInstance()->executeS($query);

        if (!is_array($results)) {
            $results = [];
        }

        foreach ($results as $key => $animal) {
            // Ajout de 'id'
            $results[$key]['id'] = $results[$key]['id_animal'];

            // Ajout de la photo
            $file_name = 'a_' . md5($results[$key]['id'] . 'animal');

            if (is_file(_PS_UPLOAD_DIR_ . $file_name . '.jpg')) {
                $results[$key]['photo'] = 'https://' . $_SERVER['HTTP_HOST'] . '/upload/' . $file_name . '.jpg?t=' . filemtime(_PS_UPLOAD_DIR_ . $file_name . '.jpg');
            } else {
                $results[$key]['photo'] = null;
            }
        }

        return $results;
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     *
     * Permet de vérifier qu'un client appartient bien au groupe de la clinique
     */
    public function checkGroup(int $id_employee): bool
    {
        $clinique = new Clinique(Clinique::getCliniqueByEmployee($id_employee));

        return in_array($this->id_default_group, [$clinique->id_group, $clinique->id_group_rural]);
    }

    public function getTotalOrders()
    {
        return $this->getStats()['total_orders'];
    }

    public function getLastVisit()
    {
        return $this->getStats()['last_visit'];
    }
}
