<?php

declare(strict_types=1);

require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'BuyLimitedNumberOfProducts.php';

/**
 * Limite la quantité d'un produit dans le panier
 */
class LimitedNumberOfProductByOrder
{
    public static function canBuyProduct(Cart $cart, Product $product, int $quantityToAdd): bool
    {
        $buyLimitedNumberOfProducts = new BuyLimitedNumberOfProducts($product->id);

        if ($buyLimitedNumberOfProducts->id_product) {
            $productInCart = $cart->getProducts(false, $product->id)[0];
            $productQuantityInCart = (int) $productInCart['cart_quantity'];

            if (($productQuantityInCart + $quantityToAdd) > $buyLimitedNumberOfProducts->max_quantity) {
                return false;
            }
        }

        return true;
    }
}
