<?php

class PostalCodeChecker
{
    const BLOCKED_POSTAL_CODE = [971, 972, 973, 974, 975, 976, 978, 986, 987, 988];

    /**
     * @throws Exception
     *
     * Lance une exception si le code postal vérifié commence par une des valeurs définies dans la constante BLOCKED_POSTAL_CODE
     */
    public function check(string $postalCode)
    {
        $postalCode = trim($postalCode);
        $postalCode = str_replace(' ', '', $postalCode);

        foreach (self::BLOCKED_POSTAL_CODE as $blockedPostalCode) {
            if ($blockedPostalCode) {
                $blockedPostalCodeLength = strlen($blockedPostalCode);
                $firstsCharsPostalCode = substr($postalCode, 0, $blockedPostalCodeLength);

                if ($firstsCharsPostalCode == $blockedPostalCode) {
                    throw new Exception('Code postal non valide.');
                }
            }
        }
    }
}
