<div id="container">
    <div class="row">
        <div class="col-lg-12">
            {if isset($success)}
                <div class="alert alert-success" role="alert">
                    {$success}
                </div>
            {/if}
            {if isset($error)}
                <div class="alert alert-danger" role="alert">
                    {$error}
                </div>
            {/if}
        </div>
        <div class="col-lg-12">
            <div class="col-lg-12 panel">
                <div class="panel-heading">
                    Configuration maintenance de l'application vétérinaire
                </div>
                <form>
                    <div class="form-group">
                        <label for="maintenanceMessageTitle">Titre du message</label>
                        <input class="form-control" name="maintenanceMessageTitle" id="maintenanceMessageTitle" value="{$messageTitle}">
                    </div>
                    <div class="form-group">
                        <label for="maintenanceMessage">Message</label>
                        <textarea class="form-control" name="maintenanceMessage" id="maintenanceMessage" rows="3">{$message}</textarea>
                    </div>

                    <div class="form-group">
                        <label for="maintenanceMessageLink">Lien</label>
                        <input class="form-control" name="maintenanceMessageLink" id="maintenanceMessageLink" value="{$messageLink}">
                    </div>

                    <div class="form-group">
                        <label for="maintenanceMessageLinkTitle">Nom du lien</label>
                        <input class="form-control" name="maintenanceMessageLinkTitle" id="maintenanceMessageLinkTitle" value="{$messageLinkTitle}">
                    </div>

                    <div class="form-group">
                        <label for="minVersion">Version minimal de l'applicaiton</label>
                        <input type="text" class="form-control" id="minVersion" name="minVersion" value="{$minVersion}" pattern="^([0-9]+)(.[0-9]+)?(.[0-9]+)?$" placeholder="ex: 1.0.0, 5.2, 10">
                    </div>
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="maintenanceMode" name="maintenanceMode" {if $maintenanceMode == 'on'}checked{/if}>
                        <label class="form-check-label" for="maintenanceMode">Activer mode maintenance (lecture uniquement)</label>
                    </div>

                    <input type="hidden" name="controller" value="AdminMyVetShopAppVetzenMaintenance">
                    <input type="hidden" name="token" value="{getAdminToken tab='AdminMyVetShopAppVetzenMaintenance'}">
                    <input type="hidden" name="action" value="updateVetoApp">

                    <br>

                    <button type="submit" class="btn btn-primary">Enregister</button>
                </form>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="col-lg-12 panel">
                <div class="panel-heading">
                    Envoi de notification sur l'application vétérinaire
                </div>
                <form>

                    <div class="form-group">
                        <label for="notificationMessageTitle">Titre de la notification (facultatif)</label>
                        <input type="text" class="form-control" name="notificationMessageTitle" id="notificationMessageTitle">
                    </div>

                    <div class="form-group">
                        <label for="notificationMessage">Notification</label>
                        <textarea class="form-control" name="notificationMessage" id="notificationMessage" rows="3" required="required"></textarea>
                    </div>

                    <label for="clinique">Cliniques</label><br>

                    <div class="row multiple-select">
                        <div class="col-lg-12 bootstrap multi-select" style="padding: 0">
                            <div class="col-lg-6">
                                <input class="multi-select-search" type="text" placeholder="Rechercher">
                            </div>
                            <br><br>
                            <div class="col-lg-6">
                                Non sélectionnés
                                <select multiple="" class="multi-select-value" size="10" style="height: 150px;">
                                    {foreach from=$cliniques item=clinique}
                                        <hr>
                                        <option value="{$clinique.id_employee}">{$clinique.code_privilege}
                                            ({$clinique.name})
                                        </option>
                                    {/foreach}
                                </select>
                                <div class="clearfix">&nbsp;</div>
                                <a class="multi-select-add-button btn btn-default btn-block">
                                    Ajouter
                                    <i class="icon-arrow-right"></i>
                                </a>
                            </div>

                            <div class="col-lg-6">
                                Sélectionnés
                                <select multiple="" class="multi-select-add" size="10" style="height: 150px;"
                                        name="notification_clinique_ids_employee[]" required="required">
                                </select>
                                <div class="clearfix">&nbsp;</div>
                                <a class="multi-select-remove-button btn btn-default btn-block">
                                    <i class="icon-arrow-left"></i>
                                    Retirer
                                </a>
                            </div>
                        </div>
                    </div>

                    <br>

                    <input type="hidden" name="controller" value="AdminMyVetShopAppVetzenMaintenance">
                    <input type="hidden" name="token" value="{getAdminToken tab='AdminMyVetShopAppVetzenMaintenance'}">
                    <input type="hidden" name="action" value="sendNotificationVetoApp">

                    <button type="submit" class="btn btn-primary">Envoyer La notification</button>
                </form>
            </div>
        </div>
    </div>
</div>


<script type="text/javascript">

    /* MULI SELECT SCRIPT */
    var buttonsAdd = document.querySelectorAll('.multi-select-add-button');
    var buttonsRemove = document.querySelectorAll('.multi-select-remove-button');
    var inputsSearch = document.querySelectorAll('.multi-select-search');

    inputsSearch.forEach(function (input) {
        input.addEventListener('keyup', function (event) {
            var searchInput = event.target;
            var searchInputParent = searchInput.parentElement.parentElement;
            var selectValueElement = searchInputParent.querySelectorAll('.multi-select-value')[0];
            var selectsOption = selectValueElement.querySelectorAll('option');
            var searchKeyword = searchInput.value;
            var regex = new RegExp(searchKeyword, "i");
            if (searchKeyword !== '') {
                selectsOption.forEach(function (selectOption) {
                    var selectedOptionValue = trim(selectOption.textContent);
                    var match = selectedOptionValue.match(regex);
                    if (match) {
                        selectOption.style.display = "flex"
                    } else {
                        selectOption.style.display = "none"
                    }
                })
            } else {
                selectsOption.forEach(function (selectOption) {
                    selectOption.style.display = "flex"
                })
            }
        })
    })


    buttonsAdd.forEach(function (buttonAdd) {
        buttonAdd.addEventListener('click', function (event) {

            var buttonAddParent = event.target.parentElement;
            var selectValueElement = buttonAddParent.querySelectorAll('.multi-select-value')[0];
            var selectedAddElement = buttonAddParent.parentElement.querySelectorAll('.multi-select-add')[0];
            var selectedValues = getSelectValues(selectValueElement)

            selectedValues.forEach(function (value) {

                var valueSelectedElement = selectValueElement.querySelector('option[value="' + value + '"]');
                valueSelectedElement.setAttribute('selected', 'selected');
                selectedAddElement.append(valueSelectedElement);
            })
        })
    })

    buttonsRemove.forEach(function (buttonRemove) {
        buttonRemove.addEventListener('click', function (event) {
            var buttonRemoveParent = event.target.parentElement;

            var selectedAddElement = buttonRemoveParent.querySelectorAll('.multi-select-add')[0];
            var selectValueElement = buttonRemoveParent.parentElement.querySelectorAll('.multi-select-value')[0];
            var selectedValues = getSelectValues(selectedAddElement)

            selectedValues.forEach(function (value) {
                var valueSelectedElement = selectedAddElement.querySelector('option[value="' + value + '"]');
                valueSelectedElement.removeAttribute('selected');
                selectValueElement.append(valueSelectedElement);
            })
        })
    })

    function getSelectValues(select) {
        var selected = [];
        for (var option of select.options) {
            if (option.selected) {
                selected.push(option.value);
            }
        }
        return selected;
    }

    function trim(string) {
        return string.replace(/^\s+/g, '').replace(/\s+$/g, '')
    }

    /* FIN MULI SELECT SCRIPT */

</script>

