<?php

declare(strict_types=1);

class AddressController extends AddressControllerCore
{
    /**
     * @throws PrestaShopException
     */
    protected function processSubmitAddress(): void
    {
        $city = Tools::getValue('city');
        if (preg_match('/[0-9]{5}/', $city)) {
            $this->errors[] = Tools::displayError('La ville "' . $city . '" n\'est pas valide.');
        }

        if (0 == count($this->errors)) {
            parent::processSubmitAddress();
        }
    }
}
