<?php

declare(strict_types=1);

require_once __DIR__ . '/../../classes/Animal.php';

class MyvetshopcliniqueMyAnimalsModuleFrontController extends ModuleFrontController
{
    /**
     * @var bool
     */
    public $display_column_left = false;

    /**
     * @throws PrestaShopException
     */
    public function init(): void
    {
        global $smarty;

        parent::init();

        $this->context->smarty = $smarty;
    }

    /**
     * @throws PrestaShopException
     */
    public function initContent(): void
    {
        parent::initContent();

        try {
            if (Tools::getValue('delete') && true == Tools::getValue('delete')) {
                $this->context->smarty->assign('success', 'L\'animal a été supprimé avec succès.');
            }

            if (Tools::getValue('update') && true == Tools::getValue('update')) {
                $this->context->smarty->assign('success', 'L\'animal a été mis à jour avec succès.');
            }

            if (Tools::getValue('create') && true == Tools::getValue('create')) {
                $this->context->smarty->assign('success', 'L\'animal a été créé avec succès.');
            }

            $result = Db::getInstance(false)
                ->executeS(
                    'SELECT a.*'
                    . ' FROM `' . _DB_PREFIX_ . 'animal` a'
                    . ' WHERE `a`.`id_customer` = ' . (int) $this->context->customer->id
                    . ' AND `a`.`deleted` = 0'
                );

            if (!is_array($result)) {
                $result = [];
            }

            $animaux = ObjectModel::hydrateCollection(
                Animal::class, $result
            );

            $this->context->smarty->assign('animaux', $animaux);
        } catch (Exception $exception) {
            $this->context->smarty->assign('error', $exception->getMessage());
        }

        $this->context->smarty->assign(['meta_title' => 'MyVetShop - Mes animaux']);
        $this->setTemplate('my_animals.tpl');
    }
}
