<?php

declare(strict_types=1);

/**
 * Created by Aurélien RICHAUD (31/07/2019 11:03)
 */
class MyvetshopcliniqueChecksModuleFrontController extends FrontController
{
    public function init(): void
    {
        header('Content-Type: application/json');

        $appVersion = Tools::getValue('app_version');

        if (!$appVersion) {
            echo json_encode([
                'message' => "<p>Erreur applicative, version inconnue. Contactez le SAV technique : <a class='external' href='mailto:contact@btoweb.fr'>contact@btoweb.fr</a></p><img src='error-dog.gif' alt=''>",
            ]);
            exit(0);
        }

        if (version_compare($appVersion, '1.1.9', '<')) {
            // Version insuffisante
            echo json_encode([
                'message' => "<p>Vous devez mettre à jour votre application pour continuer à utiliser le service. Rendez-vous sur la boutique d'application de votre smartphone pour procéder à la mise à jour.</p><img src='error-cat.gif' alt=''>",
            ]);
            exit(0);
        }

        if (!(bool) Configuration::get('PS_SHOP_ENABLE')) {
            // Mode maintenance
            echo json_encode([
                'message' => "<p>La boutique MyVetshop est actuellement en maintenance, nous vous invitons à réessayer dans quelques minutes.</p><img src='error-cat.gif' alt=''>",
            ]);
            exit(0);
        }

        // Tout est OK
        echo json_encode([]);
        exit(0);
    }
}
