<?php

declare(strict_types=1);

/**
 * Created by Aurélien RICHAUD (10/08/2017 14:18)
 */
require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'Clinique.php';
require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'CliniqueHolidays.php';

class AdminMyVetShopCliniqueHolidaysController extends ModuleAdminController
{
    /**
     * @var CliniqueHolidays
     */
    protected $object;

    public function __construct()
    {
        $this->bootstrap = true;
        $this->context = Context::getContext();
        $this->table = CliniqueHolidays::TABLE;
        $this->className = CliniqueHolidays::class;
        $this->allow_export = true;
        $this->lang = false;
        $this->fields_list = [
            'id_myvetshop_clinique_holidays' => [
                'title' => $this->l('ID'),
                'align' => 'text-center',
                'class' => 'fixed-width-xs',
            ],
            'id_myvetshop_clinique' => [
                'title' => $this->l('Clinique'),
                'havingFilter' => false,
                'callback' => 'printClinique',
            ],
            'date_alerte' => [
                'title' => $this->l('Date alerte'),
                'align' => 'text-center',
            ],
            'date_debut' => [
                'title' => $this->l('Date début'),
                'align' => 'text-center',
            ],
            'date_fin' => [
                'title' => $this->l('Date fin'),
                'align' => 'text-center',
            ],
        ];
        $this->bulk_actions = [
            'delete' => [
                'text' => $this->l('Delete selected'),
                'icon' => 'icon-trash',
                'confirm' => $this->l('Delete selected object?'),
            ],
        ];

        // Actions disponibles
        $this->addRowAction('view');
        $this->addRowAction('edit');
        $this->addRowAction('delete');

        parent::__construct();
    }

    public function printClinique(int $id_clinique): string
    {
        $clinique = new Clinique($id_clinique);
        $employee = new Employee($clinique->id_employee);

        return $employee->firstname . ' ' . $employee->lastname;
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws SmartyException
     */
    public function renderForm(): string
    {
        $cliniques = Db::getInstance(false)->executeS(
            "SELECT c.id_myvetshop_clinique AS id, CONCAT(c.code_privilege, ' - ', e.firstname, ' ', e.lastname) AS label
                  FROM " . _DB_PREFIX_ . Clinique::TABLE . ' c
                  INNER JOIN ' . _DB_PREFIX_ . 'employee e ON c.id_employee = e.id_employee
                  ORDER BY e.code_privilege ASC'
        );

        if (!is_array($cliniques)) {
            $cliniques = [];
        }

        $this->fields_form = [
            'legend' => [
                'title' => (Tools::getValue('id_myvetshop_clinique_holidays')) ? $this->l('Modifier une période de vacances') : $this->l('Ajouter une période de vacances'),
                'icon' => 'icon-angle-double-right',
            ],
            'input' => [
                [
                    'type' => 'select',
                    'label' => $this->l('Clinique'),
                    'name' => 'id_myvetshop_clinique',
                    'empty_message' => '',
                    'options' => [
                        'query' => array_merge([['id' => '', 'label' => '']], $cliniques),
                        'id' => 'id',
                        'name' => 'label',
                    ],
                    'required' => true,
                ],
                [
                    'type' => 'date',
                    'label' => $this->l('Date alerte'),
                    'name' => 'date_alerte',
                    'required' => false,
                    'col' => '3',
                ],
                [
                    'type' => 'textarea',
                    'label' => $this->l("Message d'alerte"),
                    'name' => 'message_alerte',
                    'required' => false,
                ],
                [
                    'type' => 'date',
                    'label' => $this->l('Date début'),
                    'name' => 'date_debut',
                    'required' => true,
                    'col' => '3',
                ],
                [
                    'type' => 'date',
                    'label' => $this->l('Date fin'),
                    'name' => 'date_fin',
                    'required' => true,
                    'col' => '3',
                ],
                [
                    'type' => 'textarea',
                    'label' => $this->l('Message'),
                    'name' => 'message',
                    'required' => true,
                ],
            ],
            'submit' => [
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right',
                'name' => 'saveAction',
            ],
        ];

        return parent::renderForm();
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function renderView(): string
    {
        /** @var CliniqueHolidays $holiday */
        $holiday = $this->loadObject();
        $clinique = new Clinique($holiday->id_myvetshop_clinique);

        $this->tpl_view_vars = [
            'clinique' => $clinique,
            'holiday' => $holiday,
        ];

        return parent::renderView();
    }
}
