<?php

declare(strict_types=1);

class Recommandation extends ObjectModel
{
    public const TABLE = 'recommandation';

    /**
     * @var int
     */
    public $id_customer;

    /**
     * @var int
     */
    public $id_animal;

    /**
     * @var string
     */
    public $code_reco;

    /**
     * @var string
     */
    public $date_reco;

    /**
     * @var string
     */
    public $code_clinique;

    /**
     * @var string
     */
    public $petname;

    /**
     * @var string
     */
    public $espece;

    /**
     * @var string
     */
    public $race;

    /**
     * @var int
     */
    public $id_gender;

    /**
     * @var string
     */
    public $activite;

    /**
     * @var string
     */
    public $age;

    /**
     * @var string
     */
    public $date_birth;

    /**
     * @var string
     */
    public $stade_physio;

    /**
     * @var string
     */
    public $pathologie;

    /** @var float */
    public $poids_actuel;

    /** @var float */
    public $poids_ideal;

    /** @var int */
    public $be;

    /** @var int */
    public $nbr_aliment;

    /** @var int */
    public $product_id_mvs1;

    /** @var int|null */
    public $product_id_mvs2;

    /** @var int|null */
    public $product_id_mvs3;

    /** @var int */
    public $qte_aliment1;

    /** @var int|null */
    public $qte_aliment2;

    /** @var int|null */
    public $qte_aliment3;

    /** @var int|null Nombre de mois avant la transition entre l'aliment 1 et l'aliment 2 */
    public $transition12;

    /** @var int|null Nombre de mois avant la transition entre l'aliment 2 et l'aliment 3 */
    public $transition23;

    /** @var string|null Object creation date */
    public $date_add;

    /** @var string|null Object last modification date */
    public $date_upd;

    /** @var bool */
    public $deleted = false;

    /**
     * @var array<string, mixed>
     */
    public static $definition
        = [
            'table' => self::TABLE,
            'primary' => 'id_recommandation',
            'multilang' => false,
            'multilang_shop' => false,
            'fields' => [
                'id_customer' => ['type' => self::TYPE_INT],
                'id_animal' => ['type' => self::TYPE_INT],
                'code_reco' => ['type' => self::TYPE_STRING],
                'date_reco' => ['type' => self::TYPE_DATE, 'validate' => 'isDate'],
                'code_clinique' => ['type' => self::TYPE_STRING],
                'petname' => ['type' => self::TYPE_STRING],
                'espece' => ['type' => self::TYPE_STRING],
                'race' => ['type' => self::TYPE_STRING],
                'id_gender' => ['type' => self::TYPE_INT],
                'activite' => ['type' => self::TYPE_STRING],
                'age' => ['type' => self::TYPE_STRING],
                'date_birth' => ['type' => self::TYPE_STRING],
                'stade_physio' => ['type' => self::TYPE_STRING],
                'pathologie' => ['type' => self::TYPE_STRING],
                'poids_actuel' => ['type' => self::TYPE_FLOAT],
                'poids_ideal' => ['type' => self::TYPE_FLOAT],
                'be' => ['type' => self::TYPE_INT],
                'nbr_aliment' => ['type' => self::TYPE_INT],
                'product_id_mvs1' => ['type' => self::TYPE_INT],
                'product_id_mvs2' => ['type' => self::TYPE_INT],
                'product_id_mvs3' => ['type' => self::TYPE_INT],
                'qte_aliment1' => ['type' => self::TYPE_INT],
                'qte_aliment2' => ['type' => self::TYPE_INT],
                'qte_aliment3' => ['type' => self::TYPE_INT],
                'transition12' => ['type' => self::TYPE_INT],
                'transition23' => ['type' => self::TYPE_INT],
                'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
                'date_upd' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
                'deleted' => ['type' => self::TYPE_BOOL],
            ],
        ];

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function createDiscountCode(): void
    {
        if (!$this->code_reco) {
            throw new Exception('La recommandation doit avoir un code reco');
        }

        // check si reduction avec ce code existe
        $db = Db::getInstance();

        $query = 'SELECT COUNT(id_cart_rule) AS numberOfCode FROM `' . _DB_PREFIX_ . 'cart_rule`  AS cart_rule WHERE cart_rule.code = "' . $db->escape($this->code_reco) . '"';
        $result = $db->executeS($query);

        if (is_array($result) and isset($result[0]) and isset($result[0]['numberOfCode']) and $result[0]['numberOfCode'] > 0) {
            return;
        }

        $productsId = [];

        $this->product_id_mvs1 ? array_push($productsId, $this->product_id_mvs1) : null;
        $this->product_id_mvs2 ? array_push($productsId, $this->product_id_mvs2) : null;
        $this->product_id_mvs3 ? array_push($productsId, $this->product_id_mvs3) : null;

        $now = new DateTime();

        $cartRule = new CartRule();
        $cartRule->name[1] = 'Remise recommandation';

        $cartRule->code = $this->code_reco;

        $cartRule->quantity = 1;
        $cartRule->quantity_per_user = 1;
        $cartRule->product_restriction = 1;
        $cartRule->reduction_percent = 5.00;

        // sélection poduits
        $cartRule->reduction_product = -2;

        $cartRule->date_from = $now->format('Y-m-d H:i:s');
        $dateTo = date_modify($now, '+1 year');

        if (!$dateTo instanceof DateTime) {
            throw new Exception('La date doit être un objet Datetime');
        }

        $cartRule->date_to = $dateTo->format('Y-m-d H:i:s');
        $cartRule->active = 1;

        $cartRule->save();

        //Creating rule group
        $id_cart_rule = (int) $cartRule->id;
        $sql = 'INSERT INTO ' . _DB_PREFIX_ . "cart_rule_product_rule_group (id_cart_rule, quantity) VALUES ('$id_cart_rule', 1)";
        Db::getInstance()->execute($sql);
        $id_group = (int) Db::getInstance()->Insert_ID();

        //Creating product rule
        $sql = 'INSERT INTO ' . _DB_PREFIX_ . "cart_rule_product_rule (id_product_rule_group, type) VALUES ('$id_group', 'products')";
        Db::getInstance()->execute($sql);
        $id_product_rule = (int) Db::getInstance()->Insert_ID();

        //Creating restrictions
        $values = [];
        foreach ($productsId as $id) {
            $id = (int) $id;
            $values[] = "('$id_product_rule', '$id')";
        }
        $values = implode(',', $values);
        $sql = 'INSERT INTO ' . _DB_PREFIX_ . 'cart_rule_product_rule_value (id_product_rule, id_item) VALUES ' . $values;
        Db::getInstance()->execute($sql);
    }

    /**
     * @return array<string, mixed>|null
     */
    public function getRecoProductByIdProduct(int $id_product): ?array
    {
        $db = Db::getInstance(false);

        $result = $db->getRow(
            'SELECT `p`.*, `pl`.*
             FROM `' . _DB_PREFIX_ . 'product_shop` `p`
             LEFT JOIN `' . _DB_PREFIX_ . 'product_lang` `pl` ON `pl`.`id_product` = `p`.`id_product` AND `pl`.`id_lang` = ' . (int) Context::getContext()->language->id
            . ' WHERE `p`.`id_product` = ' . (int) $id_product
            . ' AND `p`.`id_shop` = ' . (int) Context::getContext()->shop->id
        );

        if (is_array($result)) {
            return $result;
        }

        return null;
    }

    public function getRecoProductImageIdByIdProduct(int $id_product): ?int
    {
        $db = Db::getInstance(false);

        $result = $db->getValue(
            'SELECT `i`.*
             FROM `' . _DB_PREFIX_ . 'image` `i`
             WHERE `i`.`id_product` = ' . (int) $id_product . ' AND `i`.`cover` = 1'
        );

        if (!$result) {
            return null;
        }

        return (int) $result;
    }
}
