<?php

// Si on est pas exécuté depuis la ligne de commande, on arrête tout !
if ('cli' != php_sapi_name()) {
    die(1);
}

// Désactivation du timeout
set_time_limit(0);

/////////////////////////////////////////////////
// Configuration

/////////////////////////////////////////////////
// Bootstrap PrestaShop
try {
    require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'config.inc.php';
    require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'OrderExporter.php';

    // Gestion multi-boutique (au cas où) : Ce module est global
    if (Shop::isFeatureActive()) {
        Shop::setContext(Shop::CONTEXT_ALL);
    }
} catch (Exception $e) {
    echo $e->getMessage() . "\n" . $e->getTraceAsString();
    exit();
}

$context = Context::getContext();

// Workaround pour PrestaShop
$context->controller = (object) [
    'controller_type' => 'cron',
];

/// Commande #1 : France, pas de réduction, pas de remboursement
$orderExporter = new OrderExporter(
    new OrderInvoice(77485)
);

$lignes = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2019-01-01'),
    \DateTime::createFromFormat('Y-m-d', '2021-01-01')
);

if (!OrderExporter::ensureCoherent($lignes)) {
    echo "FAIL - Commande invalide : 77485\n";
    var_dump($lignes);
} else {
    echo "OK - Commande valide : 77485\n";
}

/// Commande #2 : France, pas de réduction, remboursement
$orderExporter = new OrderExporter(
    new OrderInvoice(75871)
);

$lignesCommande = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2020-01-31'),
    \DateTime::createFromFormat('Y-m-d', '2020-02-01')
);

if (!OrderExporter::ensureCoherent($lignesCommande)) {
    echo "FAIL - Commande invalide : 75871\n";
    var_dump($lignesCommande);
    exit();
} else {
    echo "OK - Commande valide : 75871\n";
}

$lignesRemboursement = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2020-03-02'),
    \DateTime::createFromFormat('Y-m-d', '2020-03-03')
);

if (!OrderExporter::ensureCoherent($lignesRemboursement)) {
    echo "FAIL - Remboursement invalide : 75871\n";
    var_dump($lignesRemboursement);
    exit();
} else {
    echo "OK - Remboursement valide : 75871\n";
}

/// Commande #3 : France, réduction, pas de remboursement
$orderExporter = new OrderExporter(
    new OrderInvoice(77471)
);

$lignes = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2019-01-01'),
    \DateTime::createFromFormat('Y-m-d', '2021-01-01')
);

if (!OrderExporter::ensureCoherent($lignes)) {
    echo "FAIL - Commande invalide : 77471\n";
    var_dump($lignes);
    exit();
} else {
    echo "OK - Commande valide : 77471\n";
}

/// Commande #4 : France, réduction, remboursement
$orderExporter = new OrderExporter(
    new OrderInvoice(69874)
);

$lignes = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2019-12-16'),
    \DateTime::createFromFormat('Y-m-d', '2019-12-17')
);

if (!OrderExporter::ensureCoherent($lignes)) {
    echo "FAIL - Commande invalide : 69874\n";
    var_dump($lignes);
    exit();
} else {
    echo "OK - Commande valide : 69874\n";
}

$lignesRemboursement = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2019-12-19'),
    \DateTime::createFromFormat('Y-m-d', '2019-12-20')
);

if (!OrderExporter::ensureCoherent($lignesRemboursement)) {
    echo "FAIL - Remboursement invalide : 69874\n";
    var_dump($lignesRemboursement);
    exit();
} else {
    echo "OK - Remboursement valide : 69874\n";
}

/// Commande #5 : Suisse, réduction, remboursement
$orderExporter = new OrderExporter(
    new OrderInvoice(19995)
);

$lignes = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2018-01-01'),
    \DateTime::createFromFormat('Y-m-d', '2021-01-01')
);

if (!OrderExporter::ensureCoherent($lignes)) {
    echo "FAIL - Commande invalide : 19995\n";
    var_dump($lignes);
    exit();
} else {
    echo "OK - Commande valide : 19995\n";
}

/// Commandes ayant spécifiquement généré des erreurs

/// Commande #6 :
$orderExporter = new OrderExporter(
    new OrderInvoice(58815)
);

$lignesCommande = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2019-09-21'),
    \DateTime::createFromFormat('Y-m-d', '2019-09-22')
);

if (!OrderExporter::ensureCoherent($lignesCommande)) {
    echo "FAIL - Commande invalide : 58815\n";
    var_dump($lignesCommande);
    exit();
} else {
    echo "OK - Commande valide : 58815\n";
}

$lignesRemboursement = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2019-10-07'),
    \DateTime::createFromFormat('Y-m-d', '2019-10-08')
);

if (!OrderExporter::ensureCoherent($lignesRemboursement)) {
    echo "FAIL - Remboursement invalide : 58815\n";
    var_dump($lignesRemboursement);
    exit();
} else {
    echo "OK - Remboursement valide : 58815\n";
}

/// Commande #7 :
$orderExporter = new OrderExporter(
    new OrderInvoice(54230)
);

$lignesCommande = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2019-08-08'),
    \DateTime::createFromFormat('Y-m-d', '2019-08-09')
);

if (!OrderExporter::ensureCoherent($lignesCommande)) {
    echo "FAIL - Commande invalide : 54230\n";
    var_dump($lignesCommande);
    exit();
} else {
    echo "OK - Commande valide : 54230\n";
}

/// Commande #8 :
$orderExporter = new OrderExporter(
    new OrderInvoice(53339)
);

$lignesCommande = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2019-07-31'),
    \DateTime::createFromFormat('Y-m-d', '2019-08-01')
);

if (!OrderExporter::ensureCoherent($lignesCommande)) {
    echo "FAIL - Commande invalide : 53339\n";
    var_dump($lignesCommande);
    exit();
} else {
    echo "OK - Commande valide : 53339\n";
}

$lignesRemboursement = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2019-08-28'),
    \DateTime::createFromFormat('Y-m-d', '2019-08-29')
);

if (!OrderExporter::ensureCoherent($lignesRemboursement)) {
    echo "FAIL - Remboursement invalide : 53339\n";
    var_dump($lignesRemboursement);
    exit();
} else {
    echo "OK - Remboursement valide : 53339\n";
}

/// Commande #9 :
$orderExporter = new OrderExporter(
    new OrderInvoice(48424)
);

$lignesCommande = $orderExporter->getLignesComptables(
    \DateTime::createFromFormat('Y-m-d', '2019-06-17'),
    \DateTime::createFromFormat('Y-m-d', '2019-06-18')
);

if (!OrderExporter::ensureCoherent($lignesCommande)) {
    echo "FAIL - Commande invalide : 48424\n";
    var_dump($lignesCommande);
    exit();
} else {
    echo "OK - Commande valide : 48424\n";
}

/// Tests systématique sur toutes les factures
$totalTests = 0;
$totalSuccess = 0;
$startDate = DateTimeImmutable::createFromFormat('Y-m-d', '2019-01-01');
$dateDiff = (new DateTime())->diff($startDate);
// Nombre de mois entre maintenant et le le 01/01/2019
$nbMonths = $dateDiff->y * 12 + $dateDiff->m;

for ($i = 0; $i <= $nbMonths; ++$i) {
    $start = $startDate->add(new DateInterval('P' . $i . 'M'));
    $end = $startDate->add(new DateInterval('P' . ($i + 1) . 'M'));

    echo '-> ' . $start->format('Y-m-d') . ' -> ' . $end->format('Y-m-d') . "\n";
    /** @var OrderInvoice[] $invoices */
    $invoices = ObjectModel::hydrateCollection(
        OrderInvoice::class,
        Db::getInstance(false)
            ->executeS('SELECT * FROM ps_order_invoice i WHERE date_add >= "' . $start->format('Y-m-d') . '" AND date_add < "' . $end->format('Y-m-d') . '"')
    );

    foreach ($invoices as $invoice) {
        $orderExporter = new OrderExporter($invoice);
        try {
            ++$totalTests;

            $lignes = $orderExporter->getLignesComptables(
                \DateTime::createFromFormat('Y-m-d', '2019-01-01'),
                \DateTime::createFromFormat('Y-m-d', '2021-01-01')
            );

            if (!OrderExporter::ensureCoherent($lignes)) {
                echo "\t - FAIL - Commande invalide : " . $invoice->id . "\n";
                var_dump($lignes);
            } else {
                echo "\t - OK - Commande valide : " . $invoice->id . "\n";
                ++$totalSuccess;
            }
        } catch (Exception $e) {
            echo "\t - FAIL - Commande invalide : " . $invoice->id . ' :: ' . $e->getMessage() . "\n";
        }
    }
}

echo "--- Fin des tests :\n";
echo "\t - Total commandes testées : " . $totalTests . "\n";
echo "\t - Total commandes valides : " . $totalSuccess . "\n";
echo "\t - Total erreurs : " . ($totalTests - $totalSuccess) . "\n";
