<?php

declare(strict_types=1);

/**
 * Copyright (c) 2015 BtoWeb.fr (Aurélien RICHAUD)
 *
 * Created 05/10/2015 17:51 by Aurélien RICHAUD
 */
class AuthController extends AuthControllerCore
{
    /**
     * @throws PrestaShopDatabaseException
     */
    protected function processSubmitAccount(): void
    {
        $city = Tools::getValue('city');
        if (preg_match('/[0-9]{5}/', $city)) {
            $this->errors[] = Tools::displayError('La ville "' . $city . '" n\'est pas valide.');
        }

        $codePrivilege = Tools::getValue('code_privilege');

        if ($codePrivilege) {
            $resultat = Db::getInstance()->executeS(
                '
                SELECT g.id_group
                FROM `' . _DB_PREFIX_ . 'group_lang` g
			WHERE g.id_group > 3
			AND g.name LIKE "' . Db::getInstance()->escape($codePrivilege) . '"
            '
            );

            if (!is_array($resultat)) {
                $resultat = [];
            }

            if (0 == count($resultat)) {
                $this->errors[] = Tools::displayError(
                    'Code privilège invalide'
                );
            }
        }

        if (0 == count($this->errors)) {
            parent::processSubmitAccount();
        }
    }
}
