<?php

// Si on est pas exécuté depuis la ligne de commande, ou si la mauvaise secure_key est envoyée, on arrête tout !
if ('cli' != php_sapi_name()) {
    die(1);
}

// Désactivation du timeout
set_time_limit(0);

/////////////////////////////////////////////////
// Configuration

/////////////////////////////////////////////////
// Bootstrap PrestaShop
try {
    require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'config.inc.php';
    require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'Clinique.php';
    require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'class' . DIRECTORY_SEPARATOR . 'NotificationManager.php';

    // Gestion multi-boutique (au cas où) : Ce module est global
    if (Shop::isFeatureActive()) {
        Shop::setContext(Shop::CONTEXT_ALL);
    }
} catch (Exception $e) {
    echo $e->getMessage() . "\n" . $e->getTraceAsString();
    exit();
}

$context = Context::getContext();

// Workaround pour PrestaShop
$context->controller = (object) [
    'controller_type' => 'cron',
];
$notificationManager = new NotificationManager();

$result = Db::getInstance()
    ->executeS('SELECT * FROM `ps_customer_push` WHERE `deleted` = 0 GROUP BY `push_id` ORDER BY `id_customer_push` DESC');

if (!is_array($result)) {
    $result = [];
}

/** @var CustomerPush[] $customerPushes */
$customerPushes = ObjectModel::hydrateCollection(
    CustomerPush::class, $result
);

foreach ($customerPushes as $customerPush) {
    echo $customerPush->push_id . "\n";
    try {
        $notificationManager->sendNotification($customerPush, "Une nouvelle version de l'application MyVetshop est disponible dans votre store. Bonne rentrée à toutes et à tous.🐶🐱");
    } catch (\GuzzleHttp\Exception\GuzzleException $e) {
        // Inhibiteur d'erreur
        //var_dump($e);
    } catch (\Exception $exception) {
        // Inhibiteur d'erreur
        //var_dump($exception);
    }
}
