<?php

declare(strict_types=1);
/**
 * Created by Aurélien RICHAUD (01/08/2017 16:51)
 */
class CliniqueHolidays extends ObjectModel
{
    public const TABLE = 'myvetshop_clinique_holidays';

    /**
     * @var int
     */
    public $id_myvetshop_clinique_holidays;

    /**
     * @var int
     */
    public $id_myvetshop_clinique;

    /**
     * @var string
     */
    public $date_alerte;

    /**
     * @var string
     */
    public $date_debut;

    /**
     * @var string
     */
    public $date_fin;

    /**
     * @var string
     */
    public $message_alerte;

    /**
     * @var string
     */
    public $message;

    /**
     * @var array<string, mixed>
     *
     * @see ObjectModel::$definition
     */
    public static $definition
        = [
            'table' => self::TABLE,
            'primary' => 'id_myvetshop_clinique_holidays',
            'multilang' => false,
            'multilang_shop' => false,
            'fields' => [
                // Clés étrangères
                'id_myvetshop_clinique' => ['type' => self::TYPE_INT, 'required' => true],
                'date_alerte' => ['type' => self::TYPE_DATE, 'required' => false],
                'date_debut' => ['type' => self::TYPE_DATE, 'required' => true],
                'date_fin' => ['type' => self::TYPE_DATE, 'required' => true],
                'message_alerte' => ['type' => self::TYPE_STRING, 'required' => false, 'size' => 1000],
                'message' => ['type' => self::TYPE_STRING, 'required' => true, 'size' => 1000],
            ],
        ];
}
