<?php

// Compatibilité PrestaShop 1.7
if (!class_exists('\GuzzleHttp\Client')) {
    require_once __DIR__ . '/../vendor/autoload.php';
}

require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'CustomerPush.php';

/**
 *  Doc: https://github.com/rs/pushd
 */
class NotificationManager
{
    /**
     * @var \GuzzleHttp\Client
     */
    protected $client;

    /**
     * @var string
     */
    public const SUBSCRIBER_GROUP_CUSTOMER = 'mvsmobile_';
    /**
     * @var string
     */
    public const SUBSCRIBER_GROUP_CLINIQUE = 'vetzenmobile_';

    /**
     * @var string
     */
    public const PUSH_SERVER_URL_APP_MYVETSHOP = 'http://myvetshop-pushd:8080/';

    /**
     * @var string
     */
    public const PUSH_SERVER_URL_APP_VETZEN = 'http://myvetshop-pushd-vetzen:8080/';

    public function __construct()
    {
        $this->client = new \GuzzleHttp\Client();
    }

    /**
     * Envoi d'une notification à un utilisateur.
     */
    public function sendNotification(CustomerPush $customerPush, string $message, ?string $title = null): void
    {
        $this->send(
            $customerPush->push_id,
            (string) $customerPush->id,
            $customerPush->push_type,
            self::SUBSCRIBER_GROUP_CUSTOMER,
            $message,
            self::PUSH_SERVER_URL_APP_MYVETSHOP,
            $title
        );
    }

    public function sendCliniqueNotification(CliniquePush $cliniquePush, string $message, ?string $title = null): void
    {
        $this->send(
            $cliniquePush->push_id,
            $cliniquePush->id_clinique_push,
            $cliniquePush->push_type,
            self::SUBSCRIBER_GROUP_CLINIQUE,
            $message,
            self::PUSH_SERVER_URL_APP_VETZEN,
            $title
        );
    }

    private function send(
        string $pushToken,
        string $pushId,
        string $pushType,
        string $subscriberGroup,
        string $message,
        string $pushServerUrl,
        ?string $title = null
    ): void {
        // On enregistre le PushID auprès de plusieurs subscriptions en fonction de l'utilisateur
        $subscribedPushReponse = $this->client->request(
            'POST',
            $pushServerUrl . 'subscribers',
            [
                'form_params' => [
                    'proto' => strtolower($pushType),
                    'token' => $pushToken,
                    'lang' => 'fr',
                ],
            ]
        );
        // Récupère l'ID dans PushD
        $subscribedPushId = str_replace('/subscriber/', '', $subscribedPushReponse->getHeader('Location')[0]);

        $this->client->request(
            'POST',
            $pushServerUrl . 'subscriber/' . $subscribedPushId . '/subscriptions/' . $subscriberGroup . $pushId
        );

        $notifContent = ['msg' => $message];

        if ($title) {
            $notifContent['title'] = $title;
        }

        /////////////////////////////////////////
        /// On envoi une notif à l'event ayant le nom d'utilisateur
        $this->client->request(
            'POST',
            $pushServerUrl . 'event/' . $subscriberGroup . $pushId,
            [
                'form_params' => $notifContent,
            ]
        );
    }
}
