<?php

declare(strict_types=1);

class CliniquePush extends ObjectModel
{
    /**
     * @var string
     */
    public const TABLE = 'clinique_push';

    /** @var int */
    public $id_clinique_push;

    /**
     * @var string
     */
    public $push_id;

    /**
     * @var string
     */
    public $push_type;

    /**
     * @var int
     */
    public $id_oauth_access_token;

    /**
     * @var string Object creation date
     */
    public $date_add;

    /**
     * @var string Object last modification date
     */
    public $date_upd;

    /**
     * @var array<string, mixed>
     *
     * @see ObjectModel::$definition
     */
    public static $definition
        = [
            'table' => self::TABLE,
            'primary' => 'id_clinique_push',
            'multilang' => false,
            'multilang_shop' => false,
            'fields' => [
                'push_id' => ['type' => self::TYPE_STRING],
                'push_type' => ['type' => self::TYPE_STRING],
                'id_oauth_access_token' => ['type' => self::TYPE_INT],
                'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
                'date_upd' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
            ],
        ];

    public static function getCLiniquePushByToken(string $token): ?CliniquePush
    {
        $db = Db::getInstance(false);

        $resultat = $db->getRow(
            '
                    SELECT *
                    FROM `' . _DB_PREFIX_ . self::TABLE . '` push
                    WHERE `push`.`push_id` = "' . $db->escape($token) . '"'
        );

        if (!is_array($resultat)) {
            return null;
        }

        $cliniquePush = new CliniquePush();
        $cliniquePush->hydrate($resultat);

        return $cliniquePush;
    }
}
