{capture name=path}<a href="{$link->getPageLink('my-account', true)|escape:'html'}" title="Mon compte" rel="nofollow" style="padding-right: 30px">Mon compte</a><span class="navigation-pipe">{$navigationPipe}</span>Mes recommandations{/capture}
<style>
    .modal-open {
        overflow: hidden;
    }
    .modal {
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 9999999999999;
        display: none;
        overflow: hidden;
        -webkit-overflow-scrolling: touch;
        outline: 0;
    }
    .modal.fade .modal-dialog {
        -webkit-transition: -webkit-transform .3s ease-out;
        -o-transition:      -o-transform .3s ease-out;
        transition:         transform .3s ease-out;
        -webkit-transform: translate(0, -25%);
        -ms-transform: translate(0, -25%);
        -o-transform: translate(0, -25%);
        transform: translate(0, -25%);
    }
    .modal.in .modal-dialog {
        -webkit-transform: translate(0, 0);
        -ms-transform: translate(0, 0);
        -o-transform: translate(0, 0);
        transform: translate(0, 0);
    }
    .modal-open .modal {
        overflow-x: hidden;
        overflow-y: auto;
    }
    .modal-dialog {
        position: relative;
        width: auto;
        margin: 10px;
    }
    .modal-content {
        position: relative;
        background-color: #fff;
        -webkit-background-clip: padding-box;
        background-clip: padding-box;
        border: 1px solid #999;
        border: 1px solid rgba(0, 0, 0, .2);
        border-radius: 6px;
        outline: 0;
        -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, .5);
        box-shadow: 0 3px 9px rgba(0, 0, 0, .5);
    }
    .modal-backdrop {
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 99999999;
        background-color: #000;
    }
    .modal-backdrop.fade {
        filter: alpha(opacity=0);
        opacity: 0;
    }
    .modal-backdrop.in {
        filter: alpha(opacity=50);
        opacity: .5;
    }
    .modal-header {
        min-height: 16.42857143px;
        padding: 15px;
        border-bottom: 1px solid #e5e5e5;
    }
    .modal-header .close {
        margin-top: -2px;
    }
    .modal-title {
        margin: 0;
        line-height: 1.42857143;
    }
    .modal-body {
        position: relative;
        padding: 15px;
    }
    .modal-footer {
        padding: 15px;
        text-align: right;
        border-top: 1px solid #e5e5e5;
    }
    .modal-footer .btn + .btn {
        margin-bottom: 0;
        margin-left: 5px;
    }
    .modal-footer .btn-group .btn + .btn {
    ;
    }
    .modal-footer .btn-block + .btn-block {
        margin-left: 0;
    }
    .modal-scrollbar-measure {
        position: absolute;
        top: -9999px;
        width: 50px;
        height: 50px;
        overflow: scroll;
    }

    @media (min-width: 768px) {
        .modal-dialog {
            width: 600px;
            margin: 30px auto;
        }
        .modal-content {
            -webkit-box-shadow: 0 5px 15px rgba(0, 0, 0, .5);
            box-shadow: 0 5px 15px rgba(0, 0, 0, .5);
        }
        .modal-sm {
            width: 300px;
        }
    }
    @media (min-width: 992px) {
        .modal-lg {
            width: 900px;
        }
    }

    td {
        background-color: white;
    }

    th {
        vertical-align: middle !important;
    }

</style>
<h1 class="page-heading">Mes recommandations</h1>

{if isset($smarty.get.add) && $smarty.get.add == 'true' }
    <div class="alert alert-success" role="alert">
        Recommandation ajoutée avec succès.
    </div>
{/if}

{if isset($smarty.get.add) && $smarty.get.add == 'false' }
    <div class="alert alert-danger" role="alert">
        Une erreur s'est produite lors de l'ajout de la recommandation.
    </div>
{/if}

{if isset($smarty.get.update) && $smarty.get.update == 'true' }
    <div class="alert alert-success" role="alert">
        La recommandation a bien été mise à jour.
    </div>
{/if}

{if isset($smarty.get.update) && $smarty.get.update == 'false' }
    <div class="alert alert-danger" role="alert">
        Une erreur s'est produite lors de la mise à jour de la recommandation.
    </div>
{/if}

{if isset($smarty.get.delete) && $smarty.get.delete == 'true' }
    <div class="alert alert-success" role="alert">
        La recommandation a bien été supprimée.
    </div>
{/if}

{if isset($smarty.get.delete) && $smarty.get.delete == 'false' }
    <div class="alert alert-danger" role="alert">
        Une erreur s'est produite lors de la suppression de la recommandation.
    </div>
{/if}


{include file='./_block_add_reco.tpl'}

{if $logged}

<h1 class="page-heading">Liste des recommandations</h1>

<div class="block-center">
    {if $animaux}
        {foreach $animaux as $animal}
            {assign var="age" value=$animal->getAge()}
            {assign var="reco" value=$animal->getReco()}

            {if $reco}
                {assign var="hasReco" value=true}
                <span id="anchor-reco-{$reco.id_recommandation}" style="padding: 63px;"></span>
                <form id="form-reco-{$reco.id_recommandation}" action="{$link->getModuleLink('myvetshopclinique', 'myreco', ['action' => 'update', 'id' => $reco.id_recommandation], true)|escape:'html'}" method="post">
                    <div class="box">
                        <h1>Pour le {$animal->espece} {$animal->nom}</h1>
                        <br>
                        <table class="table table-bordered">
                            <tr>
                                <th>Code RECO</th>
                                <td>{$reco.code_reco}</td>
                            </tr>
                            <tr>
                                <th>Date d'édition</th>
                                <td>{$reco.date_reco|date_format:"%d/%m/%Y"}</td>
                            </tr>
                            <tr>
                                <th>Fiche animal associée</th>
                                <td>
                                    <div class="row" style="padding-right: 5px;">
                                        <div class="col-sm-7" style="padding: 8px">
                                            <select id="reco-{$reco.id_recommandation}-animal" name="animal" style="vertical-align: middle; width: 100%">
                                                {foreach $allAnimals as $animalSelect}
                                                    {if $animalSelect->espece == $reco.espece}
                                                        <option {if $animal->id === $animalSelect->id}selected=selected{/if} value="{$animalSelect->id}">{$animalSelect->nom}</option>
                                                    {/if}
                                                {/foreach}
                                            </select>
                                        </div>
                                        <div class="col-sm-4" style="padding: 8px;"><a href="{$link->getModuleLink('myvetshopclinique', 'myanimal', ['id' => $animal->id ])|escape:'htmlall':'UTF-8'}" class="btn btn-default button button-small"> <span> <i
                                                            class="icon-paw"></i> Fiche Animal </span>
                                            </a></div>
                                    </div>

                                </td>
                            </tr>
                            <tr>
                                <th>Bon de réduction</th>
                                <td>
                                    {if $reco.discount_code && $reco.discount_code_quantity > 0 && $reco.discount_code_active == 1 }
                                        Code réduction : <strong>{$reco.discount_code}</strong>
                                    {else}
                                        Aucun bon de réduction
                                    {/if}
                                </td>
                            </tr>
                            <tr>
                                <th>Consulter</th>
                                <td>
                                    <a target="_blank" href="{$link->getModuleLink('myvetshopclinique', 'myreco')|escape:'htmlall':'UTF-8'}?action=pdf&id_reco={$reco.id_recommandation}" class="btn btn-default button button-small">
                            <span>
                                <i class="icon-file-pdf-o"></i>
                                PDF
                            </span>
                                    </a>
                                </td>
                            </tr>
                        </table>
                        <h2>Produit(s)</h2>
                        <br>

                        {include file='./_table_reco.tpl'}

                        <div>
                            <p style="text-align: end"> * veuillez <a target="_blank" href="{$link->getModuleLink('myvetshopclinique', 'myreco')|escape:'htmlall':'UTF-8'}?action=pdf&id_reco={$reco.id_recommandation}"
                                                                      style="text-decoration: underline">consuler
                                    le
                                    PDF</a>
                                pour le détail des
                                quantités journalières en fonction de l'âge de votre animal</p>
                        </div>
                        <ul class="footer_links" style="margin-top: 12px; border: 0">
                            <li>
                                <button class="btn btn-default button button-small" data-toggle="modal" data-target="#modal-delete-reco-{$reco.id_recommandation}" title="Supprimer">
                                    <span>Supprimer <i class="icon-remove"></i></span>
                                </button>

                                <!-- Modal -->
                                <div class="modal fade" id="modal-delete-reco-{$reco.id_recommandation}" tabindex="-1" role="dialog" aria-labelledby="modal-delete-reco-{$reco.id_recommandation}-label">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close close-modal" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                                <h4 class="modal-title" id="modal-delete-reco-{$reco.id_recommandation}-label">Voulez-vous vraiment supprimer cette recommandation ?</h4>
                                            </div>
                                            <div class="modal-footer" style="border-top: 0">
                                                <button type="button" class="close-modal btn btn-default" data-dismiss="modal">Annuler</button>
                                                <a type="button" href="{$link->getModuleLink('myvetshopclinique', 'myreco', ['action' => 'delete', 'id' => $reco.id_recommandation], true)|escape:'html'}" class="btn btn-danger">Supprimer</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </li>
                            <li>
                                <button class="btn btn-default button button-small" type="submit" title="Mettre à jour">
                                    <span>Mettre à jour <i class="icon-chevron-right"></i></span>
                                </button>
                            </li>
                        </ul>
                    </div>
                </form>
            {/if}
        {/foreach}
        {if !isset($hasReco)}
            Aucune recommandation enregistrée
        {/if}
    {else}
        Aucune recommandation enregistrée
    {/if}
</div>

{/if}

<script>
    $(".close-modal").click(function () {
        $('.modal').modal('hide')
    });
</script>
