<?php

declare(strict_types=1);

require_once _PS_MODULE_DIR_ . 'myvetshopclinique' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'Clinique.php';

class AdminCustomersController extends AdminCustomersControllerCore
{
    public function __construct()
    {
        parent::__construct();

        $cookieContent = Context::getContext()->cookie->getAll();
        if (isset($cookieContent['profile']) && 5 == $cookieContent['profile']) {
            $idGroup = Db::getInstance()->getRow(
                'SELECT id_group
                FROM `' . _DB_PREFIX_ . Clinique::TABLE . '`
                WHERE id_employee = ' . (int) $cookieContent['id_employee']
            );

            if (is_array($idGroup) && isset($idGroup['id_group'])) {
                $idGroup = $idGroup['id_group'];
            } else {
                $idGroup = 0;
            }

            // Traitement spécifique pour les cliniques vétérinaires
            $this->_join .= ' INNER JOIN `' . _DB_PREFIX_ . 'customer_group` cg ON (cg.`id_customer` = a.`id_customer` AND cg.`id_group` = ' . (int) $idGroup . ')';
        }

        $this->fields_list = array_merge($this->fields_list, [
            'id_default_group' => [
                'title' => $this->l('Code Privilège'),
                'align' => 'text-center',
                'type' => 'string',
                'callback' => 'printCodePrivilege',
                'orderby' => false,
            ],
        ]);
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function printCodePrivilege(string $value): string
    {
        $group = new Group($value);

        return $group->name[Context::getContext()->language->id];
    }
}
