<?php

declare(strict_types=1);

/**
 * @see ObjectModel::$definition
 */
Carrier::$definition['fields']['domicile'] = [
    'type' => ObjectModel::TYPE_INT,
    'required' => true,
];

/**
 * Copyright (c) 2015 BtoWeb.fr (Aurélien RICHAUD)
 *
 * Created 27/01/2016 18:38 by Aurélien RICHAUD
 */
class Carrier extends CarrierCore
{
    /**
     * @var int
     */
    public $domicile;

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function getStore(): Store
    {
        // Chargement de la classe Clinique au besoin
        require_once _PS_MODULE_DIR_ . 'myvetshopclinique' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'Clinique.php';

        $clinique_id = Clinique::getCliniqueByCarrier($this->id);
        $clinique = new Clinique($clinique_id);

        return new Store($clinique->id_store);
    }
}
