<?php

declare(strict_types=1);

/**
 * Created by Aurélien RICHAUD (31/07/2019 10:02)
 */
require_once __DIR__ . DIRECTORY_SEPARATOR . 'ApiFrontController.php';
require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'Clinique.php';
require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'OAuthAccessToken.php';

class MyvetshopcliniqueSsoselfModuleFrontController extends ApiFrontController
{
    /**
     * Assign template vars related to page content
     *
     * @see FrontController::initContent()
     */
    public function initContent(): void
    {
        parent::initContent();

        $customer = $this->context->customer;

        $ret = [
            'id' => $customer->id,
            'firstname' => $customer->firstname,
            'lastname' => $customer->lastname,
            'email' => $customer->email,
            'fullname' => $customer->firstname . ' ' . $customer->lastname,
            'clinique' => null,
        ];

        $id_clinique = Clinique::getCliniqueByGroup($customer->id_default_group);

        if ($id_clinique) {
            $clinique = new Clinique($id_clinique);
            $store = new Store($clinique->id_store);
            $employee = new Employee($clinique->id_employee);

            if (!$clinique->message) {
                $clinique->message = '<h1>INFORMATIONS IMPORTANTES</h1>
						<p>Compte tenu de la situation face au coronavirus, nous vous invitons à respecter les consignes suivantes :</p>
						<ul>
							<li style="list-style-type: circle; font-weight: bold;">Prendre contact directement avec votre propre clinique vétérinaire. Vous serez assurés de connaître ses nouveaux horaires d’ouvertures et protocoles pour récupérer vos commandes au mieux</li>
							<li style="list-style-type: circle; font-weight: bold;">Venir seul</li>
							<li style="list-style-type: circle; font-weight: bold;">Limiter les contacts avec d’autres personnes en zone d’accueil</li>
						</ul>
						<p>
							En cas d’évolution de la situation, nous vous tiendrons informés.<br>
							Merci de votre compréhension.
							<br>
						</p>';
            }

            $ret['clinique'] = [
                'name' => $employee->firstname . ' ' . $employee->lastname,
                'logo' => 'https://' . Configuration::get('PS_SHOP_DOMAIN_SSL') . '/img/tmp/employee_' . (int) $clinique->id_employee . '.jpg',
                'photo' => 'https://' . Configuration::get('PS_SHOP_DOMAIN_SSL') . '/img/tmp/store_' . (int) $clinique->id_store . '.jpg',
                'theme' => $clinique->theme,
                'code_privilege' => $clinique->code_privilege,
                'centrale' => $clinique->centrale,
                'address1' => $store->address1,
                'address2' => $store->address2,
                'postcode' => $store->postcode,
                'city' => $store->city,
                'hours' => $store->getWsHours(),
                'telephone' => $store->phone,
                'url_rendez_vous' => $clinique->url_rendez_vous,
                'jours_livraison' => $clinique->jours_livraison,
                'website' => $store->website,
                'message' => $clinique->message,
                'veterinaires' => [],
            ];

            if ($clinique->vetoAnom && $clinique->vetoAprenom && $clinique->vetoAurlrdv) {
                $ret['clinique']['veterinaires'][] = [
                    'nom' => $clinique->vetoAnom,
                    'prenom' => $clinique->vetoAprenom,
                    'url_rdv' => $clinique->vetoAurlrdv,
                ];
            }

            if ($clinique->vetoBnom && $clinique->vetoBprenom && $clinique->vetoBurlrdv) {
                $ret['clinique']['veterinaires'][] = [
                    'nom' => $clinique->vetoBnom,
                    'prenom' => $clinique->vetoBprenom,
                    'url_rdv' => $clinique->vetoBurlrdv,
                ];
            }

            if ($clinique->vetoCnom && $clinique->vetoCprenom && $clinique->vetoCurlrdv) {
                $ret['clinique']['veterinaires'][] = [
                    'nom' => $clinique->vetoCnom,
                    'prenom' => $clinique->vetoCprenom,
                    'url_rdv' => $clinique->vetoCurlrdv,
                ];
            }

            if ($clinique->vetoDnom && $clinique->vetoDprenom && $clinique->vetoDurlrdv) {
                $ret['clinique']['veterinaires'][] = [
                    'nom' => $clinique->vetoDnom,
                    'prenom' => $clinique->vetoDprenom,
                    'url_rdv' => $clinique->vetoDurlrdv,
                ];
            }

            if ($clinique->vetoEnom && $clinique->vetoEprenom && $clinique->vetoEurlrdv) {
                $ret['clinique']['veterinaires'][] = [
                    'nom' => $clinique->vetoEnom,
                    'prenom' => $clinique->vetoEprenom,
                    'url_rdv' => $clinique->vetoEurlrdv,
                ];
            }
        }

        echo json_encode($ret, JSON_PRETTY_PRINT);
        exit();
    }
}
